
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function qqglTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('计划进度面板.xlsx', '前期管理');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["前期管理基础数据","前期管理数据", "前期设计", "证照办理", "动迁腾地", "前期设计详细数据", "证照办理详细数据", "动迁腾地详细数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;     
}

export function xxjdTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('计划进度面板.xlsx', '形象进度');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["形象进度数据","形象进度详细数据","车站详细数据","旁通道详细数据","盾构机详细数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}

export function lcbjdwcqkTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('计划进度面板.xlsx', '里程碑节点完成情况');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["里程碑节点完成情况"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
     
}