
import { changeListObjectToListByReflect, changeObjectKey, changeObjectToList, designativListKeyAddUnit, getDesignativByReflect } from "../../dataPackage/interfaceAnalysis";
import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

        
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);

        if ( (type == "array" && !dataIsArray) || (type == "object" && dataIsArray) || 
            (type == "object" && fileType != "object") || (type != "array" && fileType != type) ) {
            throw new BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }

        let onceData;
        switch (operationsType) {
            case "object_ToList": onceData= changeObjectToList(fileData, reflect); break;
            case "object_changeKey": onceData = changeObjectKey(fileData, reflect); break;
            case "list_changeKey": onceData = changeListObjectToListByReflect(fileData, reflect); break;
        }

        if (unitInfo) onceData = designativListKeyAddUnit(onceData, unitInfo);

        result[dataName] = onceData;
    }

    return result;
}


function zmxfxfbInterfaceData() {
    
    let zmxfxfbinterfaceName = "致命性风险分布";
    let zmxfxfbData:any = getInterfaceByInterfaceName(zmxfxfbinterfaceName);
            
    /*
     zmxfxfbqw = 致命性风险分布全网 ;
     zmxfxfbzmxfx = 致命性风险分布致命性风险 ;
    
    */
    let config = {"zmxfxfbqw":{"type":"array","operationsType":"list_changeKey","reflect":"","unitInfo":{}},"zmxfxfbzmxfx":{"type":"array","operationsType":"list_changeKey","reflect":"","unitInfo":{}}};

    let interfaceData = Object.assign({}, zmxfxfbData );
    let changeData = changeDataProcess('致命性风险分布', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了

}
