
import { changeListObjectToListByReflect, changeObjectKey, changeObjectToList, designativListKeyAddUnit, getDesignativByReflect } from "../../dataPackage/interfaceAnalysis";
import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

        
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);

        if ( (type == "array" && !dataIsArray) || (type == "object" && dataIsArray) || 
            (type == "object" && fileType != "object") || (type != "array" && fileType != type) ) {
            throw new BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }

        let onceData;
        switch (operationsType) {
            case "object_ToList": onceData= changeObjectToList(fileData, reflect); break;
            case "object_changeKey": onceData = changeObjectKey(fileData, reflect); break;
            case "list_changeKey": onceData = changeListObjectToListByReflect(fileData, reflect); break;
        }

        if (unitInfo) onceData = designativListKeyAddUnit(onceData, unitInfo);

        result[dataName] = onceData;
    }

    return result;
}


function dqfxjdInterfaceData() {
    
    let dqfxjdinterfaceName = "当前风险节点";
    let dqfxjdData:any = getInterfaceByInterfaceName(dqfxjdinterfaceName);
            
    /*
     dqfxzs = 当前风险指数 ;
     jk = 基坑 ;
     qj = 区间 ;
     ptd = 旁通道 ;
    
    */
    let config = {"dqfxzs":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"jk":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"qj":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"ptd":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}}};

    let interfaceData = Object.assign({}, dqfxjdData );
    let changeData = changeDataProcess('当前风险节点', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了

}
