const path = require('path');
import * as fs from "fs";
import { BizError } from "../util/bizError";
import { analysisXml } from "../util/myXML";

export let port = Number(process.env.PORT) || Number(process.argv[3]) || 7576; //如果xml里面没有配置 就会使用到这里的端口

const ConfigName = "serverConfig.xml";
export async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0,__dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo:any = await analysisXml(configStr);
		if (!configInfo || !configInfo.config) console.log("xml中无配置加载");
		else {
				let config = configInfo.config;
				port = config.port[0] || port;
				
		}

    } catch(err) {
        throw new BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}
