
import { ylghTableData } from '../../data/table/ztjsgl/ylghData';
import { getDoubleYBarChartOut, getKeyValueOut, getObjectListOut, getOnceYBarChartOut, getStringOut } from '../../dataPackage/out';
import { separateDataAndUint } from '../../dataPackage/tool';

/*引领规划*/

export function getData(req, res) {
    let excelData = ylghTableData();

    let ret:any = {};
             
    ret['csgh'] = getStringOut("城市规划", excelData['城市规划'].dataList);
    
    ret['lbt'] = getStringOut("轮播图", excelData['轮播图'].dataList);
    
    let wlghPackageData = excelData['未来规划'];
    let wlghData = [];
    wlghPackageData.forEach( info => {
        let {name, data} = info;
        let wlghList = [];
        data.forEach( item => {
            let {key, value} = item;
            let {dataNum, dataUnit} = separateDataAndUint(value);
            wlghList.push({key, value:dataNum, unit:dataUnit});
        })
        wlghData.push({name, data: wlghList});
    })
                     
    ret['wlgh'] = {title:'未来规划', dataList:wlghData};    

    res.send(ret);
}