import { jsyyTableData } from '../../data/table/ztjsgl/jsyyData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../../dataPackage/out';

/*建设运营*/

export function getData(req, res) {
    let excelData = jsyyTableData();

    let ret:any = {};

    // let jcsjPackageData = keyValuePackage(excelData['基础数据'].dataList);


    let jcsjPackageData = {};
    let jcsjPackage = excelData['基础数据'].dataList;
    
    let {key, value} = jcsjPackage[0];
    let dataUnit = value.slice(-1, value.length);
    let dataNum = value.slice(0, -1);

    let yoy = jcsjPackage[1].value;
    jcsjPackageData = {key, value:dataNum, unit:dataUnit, yoy};

    ret['jcsj'] = {title:"基础数据", dataList:jcsjPackageData};
    
    let gcjsPackageData = keyValuePackage(excelData['工程建设'].dataList);
    ret['gcjs'] = getKeyValueOut('工程建设', gcjsPackageData);
    
    let qmcyPackageData = keyValuePackage(excelData['全面创优'].dataList);
    ret['qmcy'] = getKeyValueOut('全面创优', qmcyPackageData);
    
    let zysssbPackageData = keyValuePackage(excelData['专业设施设备'].dataList);
    ret['zysssb'] = getKeyValueOut('专业设施设备', zysssbPackageData);
    
    let jsjdPackageData = keyValuePackage(excelData['建设进度'].dataList);
    ret['jsjd'] = getKeyValueOut('建设进度', jsjdPackageData);

    let jsjdzbPackageData = keyValuePackage(excelData['建设进度占比'].dataList);
    ret['jsjdzb'] = getKeyValueOut('建设进度占比', jsjdzbPackageData);
    
    let zlPackageData = keyValuePackage(excelData['质量'].dataList);
    ret['zl'] = getKeyValueOut('质量', zlPackageData);
    
    let zlhglPackageData = keyValuePackage(excelData['质量合格率'].dataList);
    ret['zlhgl'] = getKeyValueOut('质量合格率', zlhglPackageData);
    
    let gxysdbqkPackageData = keyValuePackage(excelData['各项目验收达标情况'].dataList);
    ret['gxysdbqk'] = getKeyValueOut('各项目验收达标情况', gxysdbqkPackageData);
    
    let aqPackageData = keyValuePackage(excelData['安全'].dataList);
    ret['aq'] = getKeyValueOut('安全', aqPackageData);
    
    let aqczsjPackageData = keyValuePackage(excelData['安全处置数据'].dataList);
    ret['aqczsj'] = getKeyValueOut('安全处置数据', aqczsjPackageData);
    
    let fxfbPackageData = keyValuePackage(excelData['风险分布'].dataList);
    fxfbPackageData.sort( (a, b) => {
        return b.value - a.value;
    })

    // ret['fxfb'] = getKeyValueOut('风险分布', fxfbPackageData);
    ret['fxfb'] = {title:"风险分布", dataList:fxfbPackageData, maxNum: fxfbPackageData[0].value};
    
    let jcsjyccbPackageData = keyValuePackage(excelData['监测数据异常超标'].dataList);
    jcsjyccbPackageData.sort( (a, b) => {
        return b.value - a.value;
    })
    // ret['jcsjyccb'] = getKeyValueOut('监测数据异常超标', jcsjyccbPackageData);
    ret['jcsjyccb'] = {title:"监测数据异常超标", dataList:jcsjyccbPackageData, maxNum:jcsjyccbPackageData[0].value};
 
    let gxljsjdhzPackageData = onceYBarChartPackage( excelData['各线路建设进度汇总'], '','');
    ret['gxljsjdhz'] = getOnceYBarChartOut('各线路建设进度汇总', gxljsjdhzPackageData);    
    
    let mbzPackageData = keyValuePackage(excelData['各线路建设进度汇总目标值'].dataList);
    ret['mbz'] = getKeyValueOut('各线路建设进度汇总目标值', mbzPackageData);

    res.send(ret);
} 