import { jjcyTableData } from '../../data/table/ztjsgl/jjcyData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage } from '../../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut } from '../../dataPackage/out';

/*经济产业*/

export function getData(req, res) {
    let excelData = jjcyTableData();

    let ret:any = {};

    let jcsjPackageData = keyValuePackage(excelData['基础数据'].dataList);
    ret['jcsj'] = getKeyValueOut('基础数据', jcsjPackageData);

    let shdttzjsGDPPackageData = onceYBarChartPackage( excelData['上海地铁投资建设占上海GDP变化趋势'], '','');
    ret['shdttzjsGDP'] = getOnceYBarChartOut('上海地铁投资建设占上海GDP变化趋势', shdttzjsGDPPackageData);

    let dtktqhqyjgbhPackageData = doubleYBarCharPackage( excelData['地铁开通前后区域价格变化趋势'], '开通地铁后房价上浮', '元/㎡','%','');
    ret['dtktqhqyjgbh'] = getDoubleYBarChartOut('地铁开通前后区域价格变化趋势', dtktqhqyjgbhPackageData);

    let qgGDPPackageData = keyValuePackage(excelData['全国GDP'].dataList);
    ret['qgGDP'] = getKeyValueOut('全国GDP', qgGDPPackageData);

    let shGDPPackageData = keyValuePackage(excelData['上海GDP'].dataList);
    ret['shGDP'] = getKeyValueOut('上海GDP', shGDPPackageData);
                     
    res.send(ret);
}