/**
 * 建设指挥平台大屏 计划进度指标面板
 * 4月12号
 */

import { xxjdTableData } from '../../data/table/jszhpt/jhjdData';
import { tablePackage } from '../../dataPackage/inFrontOut';

/*形象进度*/
export function getData(req, res) {
    let line = req.query.line || "全部";
    let excelData = xxjdTableData();

    let ret:any = {};
    
    let xxjdsjTableDataList = tablePackage(excelData["形象进度数据"].headerList[0], excelData["形象进度数据"].bodyList);
    let 形象进度数据 = getDetailed(xxjdsjTableDataList.dataList, line, ["车站总数", "盾构机工作台数", "旁通道总数"])
    ret['xxjdsj'] = {title: "形象进度数据", dataList: 形象进度数据};

    let czxxsjTableDataList = tablePackage(excelData["车站详细数据"].headerList[0], excelData["车站详细数据"].bodyList);
    let 车站详细数据 = getValueAndProgress(czxxsjTableDataList.dataList, line, ["车站正在施工数", "车站结构封顶数"], "个")
    ret['czxxsj'] = {title: "车站详细数据", dataList: 车站详细数据};

    let dgjxxsjTableDataList = tablePackage(excelData["盾构机详细数据"].headerList[0], excelData["盾构机详细数据"].bodyList);
    let 盾构机详细数据 = getValueAndProgress(dgjxxsjTableDataList.dataList, line, ["盾构机推进里程数", "盾构机总里程数"], "km")
    ret['dgjxxsj'] = {title: "盾构机详细数据", dataList: 盾构机详细数据};

    let ptdxxsjTableDataList = tablePackage(excelData["旁通道详细数据"].headerList[0], excelData["旁通道详细数据"].bodyList);
    let 旁通道详细数据 = getValueAndProgress(ptdxxsjTableDataList.dataList, line, ["旁通道正在施工数", "旁通道完成数"], "条")
    ret['ptdxxsj'] = {title: "旁通道详细数据", dataList: 旁通道详细数据};

    res.send(ret);
}

/**
 * 形象进度详细数据特化处理
 * @param dataList 原数据
 * @param line 线路
 * @param type 类型
 * @param unit 单位
 * @returns 
 */
function getValueAndProgress(dataList, line, type, unit) {
    let result = [];
    let num = 0;
    let progressNum = 0;
    for(let i = 0; i < type.length; i++) {
        dataList.forEach( info => {
            let {A, B, C, D} = info;
            if (A == line) {
                switch (B) {
                    case type[i]:
                        result.push({key: type[i], value: C, progress:D + "%", unit});
                    break;
                }
                
            } else if (line == "全部") {
                switch (B) {
                    case type[i]:
                        num = parseFloat(C) + num;
                        progressNum = parseFloat(D) + progressNum;
                    break;
                }
                
            }
        })
        if (line == "全部") result.push({key: type[i], value: num, progress:progressNum/dataList.length + "%", unit});
    }
    
    return result;
}

/**
 * 形象进度数据特化处理
 * @param dataList 原数据
 * @param line 线路
 * @param type 类型
 * @returns 
 */
function getDetailed(dataList, line, type) {
    let result = [];
    let list = {};

    for(let i = 0; i < type.length; i++) {
        let num = 0;
        for (let key in dataList) {
            let {A, B, C} = dataList[key];
            if (A == line) {
                switch (B) {
                    case type[i]:
                        list[type[i]] = C;
                    break;
                }
            } else if (line == "全部") {
                switch (B) {
                    case type[i]:
                        num = parseFloat(C) + num;
                        list[type[i]] = num;
                    break;
                }
            }
        }
    }

    for(let key in list) {
        result.push({key, value: list[key]});
    }

    return result;
}
