/**
 * 建设指挥平台大屏 计划进度指标面板
 * 4月11号
 */

import { qqglTableData } from '../../data/table/jszhpt/jhjdData';
import { keyValuePackage, tablePackage } from '../../dataPackage/inFrontOut';
import { getKeyValueOut } from '../../dataPackage/out';

/*前期管理*/
export function getData(req, res) {
    let line = req.query.line || "全部";
    let excelData = qqglTableData();

    let ret:any = {};

    let qqgljcsjTableDataList = tablePackage(excelData["前期管理基础数据"].headerList[0], excelData["前期管理基础数据"].bodyList);
    let 基础数据 = getValueAndTarget("完成情况", "年度总计划", qqgljcsjTableDataList.dataList, line)
    let jcsjPackageData = keyValuePackage(基础数据);
    ret["jcsj"] = getKeyValueOut('前期管理基础数据', jcsjPackageData)
    
    let qqsjTableDataList = tablePackage(excelData["前期设计"].headerList[0], excelData["前期设计"].bodyList);
    let 前期设计 = getValueAndTarget("前期设计", "目标值", qqsjTableDataList.dataList, line);
    ret['qqsj'] = {title: "前期设计", dataList: 前期设计};
    
    let zzblTableDataList = tablePackage(excelData["证照办理"].headerList[0], excelData["证照办理"].bodyList);
    let 证照办理 = getValueAndTarget("证照办理", "目标值", zzblTableDataList.dataList, line);
    ret['zzbl'] = {title: "证照办理", dataList: 证照办理};
    
    let dqtdTableDataList = tablePackage(excelData["动迁腾地"].headerList[0], excelData["动迁腾地"].bodyList);
    let 动迁腾地 = getValueAndTarget("动迁腾地", "目标值", dqtdTableDataList.dataList, line);
    ret['dqtd'] = {title: "动迁腾地", dataList: 动迁腾地};

    let qqsjxxsjTableDataList = tablePackage(excelData["前期设计详细数据"].headerList[0], excelData["前期设计详细数据"].bodyList);
    let 前期设计详细数据 = getqqsjDetailed(qqsjxxsjTableDataList.dataList, line, ["专项规划", "工可批复", "初设批复"])
    ret['qqsjxxsj'] = {title: "前期设计详细数据", dataList: 前期设计详细数据};

    
    let zzblxxsjTableDataList = tablePackage(excelData["证照办理详细数据"].headerList[0], excelData["证照办理详细数据"].bodyList);
    let 证照办理详细数据 = getDetailedAndTarget(zzblxxsjTableDataList.dataList, line, ["单体规划设计", "单体建设用途", "单体建设工程"])
    ret['zzblxxsj'] = {title: "证照办理详细数据", dataList: 证照办理详细数据};

    let dqtdxxsjTableDataList = tablePackage(excelData["动迁腾地详细数据"].headerList[0], excelData["动迁腾地详细数据"].bodyList);
    let 动迁腾地详细数据 = getDetailed(dqtdxxsjTableDataList.dataList, line, ["静安区", "黄浦区", "徐汇区"])
    ret['dqtdxxsj'] = {title: "动迁腾地详细数据", dataList: 动迁腾地详细数据};

    res.send(ret);
}

/**
 * 获取数据值和目标值特化处理
 * @param title 
 * @param subTitle 
 * @param dataList 
 * @param line 
 * @returns 
 */
function getValueAndTarget(title, subTitle, dataList, line) {
    let result = [];
    let num = 0;
    let targetNum = 0;
    dataList.forEach( info => {
        let {A, B, C} = info;
        if (A == line) {
            result.push({key: title, value: B}, {key: subTitle, value: C});
        } else if (line == "全部") {
            num = parseFloat(B) + num;
            targetNum = parseFloat(C) + targetNum;
            result = [{key: title, value: num}, {key: subTitle, value: targetNum}];
        }
    })

    return result;
}

/**
 * 前期设计详细数据特化处理
 * @param title 
 * @param dataList 
 * @param line 
 * @param type ['专项规划', '工可批复', '初设批复']
 */
function getqqsjDetailed(dataList, line, type) {
    let result = [];
    let list = {};

    for(let i = 0; i < type.length; i++) {
        outer: for (let key in dataList) {
            let {A, B, C} = dataList[key];
            if (A == line) {
                switch (B) {
                    case type[i]:
                        list[type[i]] = C;
                    break;
                }
            } else if (line == "全部") {
                switch (B) {
                    case type[i]:
                        if(C == "完成") {
                            list[type[i]] = C;
                        } 
                        else {
                            list[type[i]] = "未完成"; 
                            break outer;
                        }
                    break;
                }
            }
        }
    }

    for(let key in list) {
        result.push({key, value: list[key]});
    }

    return result;
}


/**
 * 获取详细数据特化处理
 * @param dataList 
 * @param line 
 * @param type 
 * @returns 
 */
function getDetailed(dataList, line, type) {
    let result = [];
    let list = {};

    for(let i = 0; i < type.length; i++) {
        let num = 0;
        for (let key in dataList) {
            let {A, B, C} = dataList[key];
            if (A == line) {
                switch (B) {
                    case type[i]:
                        list[type[i]] = C;
                    break;
                }
            } else if (line == "全部") {
                switch (B) {
                    case type[i]:
                        num = parseFloat(C) + num;
                        list[type[i]] = num;
                    break;
                }
            }
        }
    }

    for(let key in list) {
        result.push({key, value: list[key]});
    }

    return result;
}

/**
 * 证照办理详细数据特化处理
 * @param dataList 
 * @param line 
 * @param type 
 * @returns 
 */
function getDetailedAndTarget(dataList, line, type) {
    let result = [];
    let list = {};

    for(let i = 0; i < type.length; i++) {
        let num = 0;
        let targetNum = 0;
        for (let key in dataList) {
            let {A, B, C, D} = dataList[key];
            if (A == line) {
                switch (B) {
                    case type[i]:
                        result.push({key: type[i], value: C, target:D});
                    break;
                }
            } else if (line == "全部") {
                switch (B) {
                    case type[i]:
                        num = parseFloat(C) + num;
                        targetNum = parseFloat(D) + targetNum;
                    break;
                }
            }
        }

        if (line == "全部") result.push({key: type[i], value: num, target:targetNum});
    }

    return result;
}
