
import { jszhptdtTableData } from '../../data/table/jszhpt/jszhptdtData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../../dataPackage/out';

/*地图*/
export function getData(req, res) {
    let excelData = jszhptdtTableData();

    let ret:any = {};

    let jcsjPackageData = keyValuePackage(excelData['基础数据'].dataList);
    ret['jcsj'] = getKeyValueOut('基础数据', jcsjPackageData);

    let dtTableDataList = tablePackage(excelData["线路列表"].headerList[0], excelData["线路列表"].bodyList);
    let dtDataList = [];
    dtTableDataList.dataList.forEach( info => {
        let {A, B} = info;
        let img =  A + ".png";
        dtDataList.push({name: A, value: B, img});
    })

    ret['dt'] = {title: '线路列表', dataList: dtDataList};

    let zbTableDataList = tablePackage(excelData["线路坐标"].headerList[0], excelData["线路坐标"].bodyList);

    let zbTableData = [];
    zbTableDataList.dataList.forEach( info => {
        let {A, B, C, D, E, F, G} = info;
        zbTableData.push({line:A, heading:B, height:C, lat:D, lng:E, pitch:F, roll:G})
    })

    ret['xlzb'] = {title: "线路坐标", dataList: zbTableData};
                     
    res.send(ret);
} 