/**
 * 建设指挥平台大屏 质量安全指标面板
 * 4月12号
 */

import { gcaqztTableData } from '../../data/table/jszhpt/jszhptdtData';
import { tablePackage } from '../../dataPackage/inFrontOut';

/*工程安全状态*/
export function getData(req, res) {
    let line = req.query.line || "全部";
    let excelData = gcaqztTableData();

    let ret:any = {};

    let xxjdsjTableDataList = tablePackage(excelData["风险期数量"].headerList[0], excelData["风险期数量"].bodyList);
    let 基坑风险期数量 = {};
    let 盾构区间风险期数量 = {};
    let 旁通道风险期数量 = {};

    let jkfxqsl = 0;
    let dgqjfxqsl = 0;
    let ptdfxqsl:any = 0;
    xxjdsjTableDataList.dataList.forEach( info => {
        let {A, B, C, D} = info;
        if (!D) D = "-";
        if (A == line) {
            基坑风险期数量 = {key: "基坑风险期数量", value: parseInt(B)};
            盾构区间风险期数量 = {key: "盾构区间风险期数量", value: parseInt(C)};
            旁通道风险期数量 = {key: "旁通道风险期数量", value: parseInt(D)};
        } else if (line == "全部") {
            jkfxqsl = parseInt(B) + jkfxqsl;
            dgqjfxqsl = parseInt(C) + dgqjfxqsl;
            if (!D) ptdfxqsl = parseInt(D) + ptdfxqsl;
            基坑风险期数量 = {key: "风险期数量", value: jkfxqsl};
            盾构区间风险期数量 = {key: "风险期数量", value: dgqjfxqsl};
            旁通道风险期数量 = {key: "风险期数量", value: ptdfxqsl};
        }
    })

    ret['jkfxqsl'] = {title: '基坑风险期数量', dataList: 基坑风险期数量};

    ret['dgqjfxqsl'] = {title: '盾构区间风险期数量', dataList: 盾构区间风险期数量};
    
    ret['ptdfxqsl'] = {title: '旁通道风险期数量', dataList: 旁通道风险期数量};
    
    let zmxfxfbTableDataList = tablePackage(excelData["工程安全状态详细数据"].headerList[0], excelData["工程安全状态详细数据"].bodyList);
    let 基坑 = [];
    let 盾构区间 = [];
    let 旁通道 = [];

    zmxfxfbTableDataList.dataList.forEach( info => { 
        let {A, B, C, D, E} = info;
        if (A == line) {
            switch (B) {
                case '基坑':
                    基坑.push({type:C, num:D, rate:E});
                break;
                case '盾构区间':
                    盾构区间.push({type:C, num:D, rate:E});
                break;
                case '旁通道':

                    旁通道.push({type:C, num:D, rate:E});
                break;
            }
        } else if(line == "全部") {
            switch (B) {
                case '基坑':
                    基坑.push({type:C, num:D, rate:E});
                break;
                case '盾构区间':
                    盾构区间.push({type:C, num:D, rate:E});
                break;
                case '旁通道':
                    旁通道.push({type:C, num:D, rate:E});
                break;
            }
        }
    }) 

    let jkxxsjPackageData = getXl(基坑);
    // let jkxxsjPackageData = keyValuePackage(基坑);
    ret['jkxxsj'] = {title: '基坑详细数据', dataList: jkxxsjPackageData};
    
    // let dgqjxxsjPackageData = keyValuePackage(盾构区间);
    let dgqjxxsjPackageData = getXl(盾构区间);
    ret['dgqjxxsj'] = {title: '盾构区间详细数据', dataList: dgqjxxsjPackageData};
    
    // let ptdxxsjPackageData = keyValuePackage(旁通道);
    let ptdxxsjPackageData = getXl(旁通道);
    ret['ptdxxsj'] = {title: '旁通道详细数据', dataList: ptdxxsjPackageData};
    
    res.send(ret);
} 

function getXl(data) {
    let result = [];
    
    let 安全 = {};
    let 风险可控 = {};
    let 重点关注 = {};

    let aqNum = 0;
    let aqRate = 0;
    let fxkkNum = 0;
    let fxkkRate = 0;
    let zdgzNum = 0;
    let zdgzRate = 0;

    data.forEach( info => {
        let {type, num, rate} = info;
        if(type == "安全") {
            aqNum = parseFloat(num) + aqNum;
            aqRate = parseFloat(rate) + aqRate;
            安全 = {key:"安全", num:aqNum, rate:aqRate};
        } else if (type == "风险可控") {
            fxkkNum = parseFloat(num) + fxkkNum;
            fxkkRate = parseFloat(rate) + fxkkRate;
            风险可控 = {key:"风险可控", num:fxkkNum, rate:fxkkRate};
        } else if (type == "重点关注") {
            zdgzNum = parseFloat(num) + zdgzNum;
            zdgzRate = parseFloat(rate) + zdgzRate;
            重点关注  = {key:"重点关注", num:zdgzNum, rate: zdgzRate};
        }
    })
    result = [安全, 风险可控, 重点关注];
    return result;
}
