/**
 * 建设指挥平台大屏 质量安全指标面板
 * 4月12号
 */

import { dqfxjdTableData } from '../../data/table/jszhpt/jszhptdtData';
import { keyValuePackage, tablePackage } from '../../dataPackage/inFrontOut';

/*当前风险节点*/
export function getData(req, res) {
    let line = req.query.line || "全部";
    let excelData = dqfxjdTableData();

    let ret:any = {};

    let xxjdsjTableDataList = tablePackage(excelData["当前风险指数"].headerList[0], excelData["当前风险指数"].bodyList);
    let 基坑变形 = {};
    let 地层损失率 = {};
    let 旁通道地表沉降 = {};

    let jkbx = 0;
    let dcssl = 0;
    let ptddbcx:any = 0;
    xxjdsjTableDataList.dataList.forEach( info => {
        let {A, B, C, D} = info;
        if (!D) D = "-";
        if (A == line) {
            基坑变形 = {key: "基坑变形", value: B};
            地层损失率 = {key: "地层损失率", value: C};
            旁通道地表沉降 = {key: "旁通道地表沉降", value: D};
        } else if (line == "全部") {
            if (B) jkbx = parseFloat(B) + jkbx;
            if (C) dcssl = parseFloat(C) + dcssl;
            if (!D) ptddbcx = parseFloat(D) + ptddbcx;
            基坑变形 = {key: "基坑变形", value: jkbx};
            地层损失率 = {key: "地层损失率", value: dcssl};
            旁通道地表沉降 = {key: "旁通道地表沉降", value: ptddbcx};
        }
    })

    ret['jkbx'] = {title: '基坑变形', dataList: 基坑变形};

    ret['dcssl'] = {title: '地层损失率', dataList: 地层损失率};
    
    ret['ptddbcx'] = {title: '旁通道地表沉降', dataList: 旁通道地表沉降};

    let xxjdxxsjTableDataList = tablePackage(excelData["风险节点数据"].headerList[0], excelData["风险节点数据"].bodyList);
    let 基坑 = [];
    let 区间 = [];
    let 旁通道 = [];

    let jk = 0;
    let qj = 0;
    let ptd = 0;

    let jkdqsl = 0;
    let qjdqsl = 0;
    let ptddqsl = 0;
    xxjdxxsjTableDataList.dataList.forEach( info => {
        let {A, B, C, D} = info;
        if (A == line) {
            switch (B) {
                case '基坑':
                    基坑.push( {key : B + "总数", value: C}, {key: "当前数量", value: D} );
                break;
                case '盾构区间':
                    区间.push( {key : B + "总数", value: C}, {key: "当前数量", value: D} );
                break;
                case '旁通道':
                    旁通道.push( {key : B + "总数", value: C}, {key: "当前数量", value: D} );
                break;
            }
        } else if (line == "全部") {
            switch (B) {
                case '基坑':
                    if (C) jk = parseInt(C) + jk;
                    if (D) jkdqsl = parseInt(D) + jkdqsl;
                    基坑 = [{key : B + "总数", value: jk}, {key: "当前数量", value: jkdqsl}];
                break;
                case '盾构区间':
                    if (C) qj = parseInt(C) + qj;
                    if (D) qjdqsl = parseInt(D) + qjdqsl;
                    区间 = [{key : B + "总数", value: qj}, {key: "当前数量", value: qjdqsl}];
                break;
                case '旁通道':
                    if (C) ptd = parseInt(C) + ptd;
                    if (D) ptddqsl = parseInt(D) + ptddqsl;
                    旁通道 = [{key : B + "总数", value: ptd}, {key: "当前数量", value: ptddqsl}];
                break;
            }
        }
    })

    let jkxxsjPackageData = keyValuePackage(基坑);
    ret['jkxxsj'] = {title: '基坑详细数据', dataList: jkxxsjPackageData};
    
    let qjxxsjPackageData = keyValuePackage(区间);
    ret['qjxxsj'] = {title: '区间详细数据', dataList: qjxxsjPackageData};
    
    let ptdxxsjPackageData = keyValuePackage(旁通道);
    ret['ptdxxsj'] = {title: '旁通道详细数据', dataList: ptdxxsjPackageData};
                     
    res.send(ret);
}
