"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysError = exports.BizError = void 0;
const errorEnum_1 = require("../config/errorEnum");
const log_1 = require("./log");
class BizError extends Error {
    constructor(...msgs) {
        let reqErrorMsg = '';
        let logErrorMsg = '';
        for (let i = 0; i < msgs.length; i++) {
            if (!i) {
                let msg = errorEnum_1.getBizMsg(msgs[i]);
                reqErrorMsg = msg;
                logErrorMsg = msg;
            }
            else {
                logErrorMsg += ` | ${msgs[i]} `;
            }
        }
        log_1.logError(logErrorMsg);
        super(reqErrorMsg);
    }
}
exports.BizError = BizError;
class SysError extends Error {
    constructor(...msgs) {
        let reqErrorMsg = '';
        let logErrorMsg = '';
        for (let i = 0; i < msgs.length; i++) {
            if (!i) {
                let msg = errorEnum_1.getSysMsg(msgs[i]);
                reqErrorMsg = msg;
                logErrorMsg = msg;
            }
            else {
                if (typeof msgs[i] == 'object')
                    logErrorMsg += ` | ${JSON.stringify(msgs[i])} `;
                else
                    logErrorMsg += ` | ${msgs[i]} `;
            }
        }
        log_1.logError(logErrorMsg);
        super(reqErrorMsg);
    }
}
exports.SysError = SysError;
//# sourceMappingURL=bizError.js.map