"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setRouter = void 0;
const asyncHandler = require("express-async-handler");
//建设指挥平台
const qqglBiz = require("../biz/jszhpt/qqgl");
const xxjdBiz = require("../biz/jszhpt/xxjd");
const lcbjdwcqkBiz = require("../biz/jszhpt/lcbjdwcqk");
const zmxfxfbBiz = require("../biz/jszhpt/zmxfxfb");
const dqfxjdBiz = require("../biz/jszhpt/dqfxjd");
const gcaqztBiz = require("../biz/jszhpt/gcaqzt");
const xlBiz = require("../biz/jszhpt/xl");
const jszhptBiz = require("../biz/jszhpt/jszhptdt");
const nfBiz = require("../biz/jszhpt/nf");
//投资管控指标面板
const gszsBiz = require("../biz/jszhpt/gszs");
const tkjsBiz = require("../biz/jszhpt/tkjs");
const jstjBiz = require("../biz/jszhpt/jstj");
//业财融合指标面板
const tzwcqkBiz = require("../biz/jszhpt/tzwcqk");
const htjeyizlBiz = require("../biz/jszhpt/htjeyjzl");
//整体建设概览
const jsyyBiz = require("../biz/ztjsgl/jsyy");
const lcbsjBiz = require("../biz/ztjsgl/lcbsj");
const jjcyBiz = require("../biz/ztjsgl/jjcy");
const lscxBiz = require("../biz/ztjsgl/lscx");
const ylghBiz = require("../biz/ztjsgl/ylgh");
const ztjsglBiz = require("../biz/ztjsgl/map");
function setRouter(httpServer) {
    /**
     * 建设指挥平台
     */
    httpServer.get('/lcbjdwcqk', asyncHandler(lcbjdwcqkBiz.getData)); //里程碑节点完成情况
    httpServer.get('/xl', asyncHandler(xlBiz.getData)); //线路
    httpServer.get('/jszhpt', asyncHandler(jszhptBiz.getData)); //地图
    httpServer.get('/qqgl', asyncHandler(qqglBiz.getData)); //前期管理
    httpServer.get('/xxjd', asyncHandler(xxjdBiz.getData)); //形象进度
    httpServer.get('/zmxfxfb', asyncHandler(zmxfxfbBiz.getData)); //致命性风险分布
    httpServer.get('/dqfxjd', asyncHandler(dqfxjdBiz.getData)); //当前风险节点
    httpServer.get('/gcaqzt', asyncHandler(gcaqztBiz.getData)); //工程安全状态
    httpServer.get('/nf', asyncHandler(nfBiz.getData)); //工程安全状态
    //投资管控指标面板
    httpServer.get('/gszs', asyncHandler(gszsBiz.getData)); //概算总数
    httpServer.get('/tkjs', asyncHandler(tkjsBiz.getData)); //投控建设
    httpServer.get('/jstj', asyncHandler(jstjBiz.getData)); //决算统计
    //业财融合指标面板
    httpServer.get('/tzwcqk', asyncHandler(tzwcqkBiz.getData)); //投资完成情况
    httpServer.get('/htjeyjzl', asyncHandler(htjeyizlBiz.getData)); //合同金额预警总览
    /**
     * 整体建设概览
     */
    httpServer.get('/jsyy', asyncHandler(jsyyBiz.getData)); //建设运营
    httpServer.get('/lcbsj', asyncHandler(lcbsjBiz.getData)); //里程碑事件&荣誉成果
    httpServer.get('/jjcy', asyncHandler(jjcyBiz.getData)); //经济产业
    httpServer.get('/lscx', asyncHandler(lscxBiz.getData)); //绿色出行
    httpServer.get('/ylgh', asyncHandler(ylghBiz.getData)); //引领/规划
    httpServer.get('/map', asyncHandler(ztjsglBiz.getData)); //地图
}
exports.setRouter = setRouter;
//# sourceMappingURL=router.js.map