"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lcbjdwcqkTableData = void 0;
const planaryArrayAnalysis_1 = require("../../dataPackage/planaryArrayAnalysis");
const analysisExcel_1 = require("../../util/analysisExcel");
function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};
    for (let i = 0; i < blockDataList.length; i++) {
        let { blockData, blockTitle } = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDecollateForIndex(blockData);
    }
    return result;
}
function lcbjdwcqkTableData() {
    let blockDataList = analysisExcel_1.onceSheetBecomeOfblockData('建设指挥平台.xlsx', '里程碑节点完成情况');
    let keyValueOrTitleList = []; //适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList = ["里程碑节点完成情况"]; //适配 表格
    let titltListConfig = {};
    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}
exports.lcbjdwcqkTableData = lcbjdwcqkTableData;
//# sourceMappingURL=lcbjdwcqkData.js.map