"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dtTableData = void 0;
const planaryArrayAnalysis_1 = require("../../dataPackage/planaryArrayAnalysis");
const analysisExcel_1 = require("../../util/analysisExcel");
function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};
    for (let i = 0; i < blockDataList.length; i++) {
        let { blockData, blockTitle } = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDecollateForIndex(blockData);
    }
    return result;
}
function dtTableData() {
    let blockDataList = analysisExcel_1.onceSheetBecomeOfblockData('建设指挥平台.xlsx', '建设指挥平台地图');
    let keyValueOrTitleList = ["基础数据"]; //适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList = ["线路列表"]; //适配 表格
    let titltListConfig = {};
    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}
exports.dtTableData = dtTableData;
//# sourceMappingURL=dtData.js.map