"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const interfaceAnalysis_1 = require("../../dataPackage/interfaceAnalysis");
const bizError_1 = require("../../util/bizError");
const cronJob_1 = require("./cronJob");
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);
        if ((type == "array" && !dataIsArray) || (type == "object" && dataIsArray) ||
            (type == "object" && fileType != "object") || (type != "array" && fileType != type)) {
            throw new bizError_1.BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }
        let onceData;
        switch (operationsType) {
            case "object_ToList":
                onceData = interfaceAnalysis_1.changeObjectToList(fileData, reflect);
                break;
            case "object_changeKey":
                onceData = interfaceAnalysis_1.changeObjectKey(fileData, reflect);
                break;
            case "list_changeKey":
                onceData = interfaceAnalysis_1.changeListObjectToListByReflect(fileData, reflect);
                break;
        }
        if (unitInfo)
            onceData = interfaceAnalysis_1.designativListKeyAddUnit(onceData, unitInfo);
        result[dataName] = onceData;
    }
    return result;
}
function xxjdInterfaceData() {
    let xxjdinterfaceName = "形象进度";
    let xxjdData = cronJob_1.getInterfaceByInterfaceName(xxjdinterfaceName);
    /*
     czzs = 车站总数 ;
     czxxsj = 车站详细数据 ;
     dgjgzts = 盾构机工作台数 ;
     dgjxxsj = 盾构机详细数据 ;
     ptdzs = 旁通道总数 ;
     ptdxxsj = 旁通道详细数据 ;
    
    */
    let config = { "czzs": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "czxxsj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "dgjgzts": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "dgjxxsj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "ptdzs": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "ptdxxsj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} } };
    let interfaceData = Object.assign({}, xxjdData);
    let changeData = changeDataProcess('形象进度', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了
}
//# sourceMappingURL=xxjdData.js.map