"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const interfaceAnalysis_1 = require("../../dataPackage/interfaceAnalysis");
const bizError_1 = require("../../util/bizError");
const cronJob_1 = require("./cronJob");
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);
        if ((type == "array" && !dataIsArray) || (type == "object" && dataIsArray) ||
            (type == "object" && fileType != "object") || (type != "array" && fileType != type)) {
            throw new bizError_1.BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }
        let onceData;
        switch (operationsType) {
            case "object_ToList":
                onceData = interfaceAnalysis_1.changeObjectToList(fileData, reflect);
                break;
            case "object_changeKey":
                onceData = interfaceAnalysis_1.changeObjectKey(fileData, reflect);
                break;
            case "list_changeKey":
                onceData = interfaceAnalysis_1.changeListObjectToListByReflect(fileData, reflect);
                break;
        }
        if (unitInfo)
            onceData = interfaceAnalysis_1.designativListKeyAddUnit(onceData, unitInfo);
        result[dataName] = onceData;
    }
    return result;
}
function jhjdInterfaceData() {
    let jhjdinterfaceName = "计划进度";
    let jhjdData = cronJob_1.getInterfaceByInterfaceName(jhjdinterfaceName);
    /*
     zjbl = 证件办理 ;
     zjblxxxl = 证件办理详细线路 ;
     dq = 动迁 ;
     dqxxxl = 动迁详细线路 ;
     yj = 移交 ;
     yjxxxl = 移交详细线路 ;
    
    */
    let config = { "zjbl": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "zjblxxxl": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "dq": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "dqxxxl": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "yj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "yjxxxl": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} } };
    let interfaceData = Object.assign({}, jhjdData);
    let changeData = changeDataProcess('计划进度', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了
}
//# sourceMappingURL=jhjdData.js.map