"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const interfaceAnalysis_1 = require("../../dataPackage/interfaceAnalysis");
const bizError_1 = require("../../util/bizError");
const cronJob_1 = require("./cronJob");
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);
        if ((type == "array" && !dataIsArray) || (type == "object" && dataIsArray) ||
            (type == "object" && fileType != "object") || (type != "array" && fileType != type)) {
            throw new bizError_1.BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }
        let onceData;
        switch (operationsType) {
            case "object_ToList":
                onceData = interfaceAnalysis_1.changeObjectToList(fileData, reflect);
                break;
            case "object_changeKey":
                onceData = interfaceAnalysis_1.changeObjectKey(fileData, reflect);
                break;
            case "list_changeKey":
                onceData = interfaceAnalysis_1.changeListObjectToListByReflect(fileData, reflect);
                break;
        }
        if (unitInfo)
            onceData = interfaceAnalysis_1.designativListKeyAddUnit(onceData, unitInfo);
        result[dataName] = onceData;
    }
    return result;
}
function gcaqztInterfaceData() {
    let gcaqztinterfaceName = "工程安全状态";
    let gcaqztData = cronJob_1.getInterfaceByInterfaceName(gcaqztinterfaceName);
    /*
     gcaqztaq = 工程安全状态安全 ;
     gcaqztfxkk = 工程安全状态风险可控 ;
     gcaqztzdgz = 工程安全状态重点关注 ;
    
    */
    let config = { "gcaqztaq": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "gcaqztfxkk": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "gcaqztzdgz": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} } };
    let interfaceData = Object.assign({}, gcaqztData);
    let changeData = changeDataProcess('工程 安全状态', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了
}
//# sourceMappingURL=gcaqztData.js.map