"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initConfig = exports.port = void 0;
const path = require('path');
const fs = require("fs");
const bizError_1 = require("../util/bizError");
const myXML_1 = require("../util/myXML");
exports.port = Number(process.env.PORT) || Number(process.argv[3]) || 7576; //如果xml里面没有配置 就会使用到这里的端口
const ConfigName = "serverConfig.xml";
async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0, __dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo = await myXML_1.analysisXml(configStr);
        if (!configInfo || !configInfo.config)
            console.log("xml中无配置加载");
        else {
            let config = configInfo.config;
            exports.port = config.port[0] || exports.port;
        }
    }
    catch (err) {
        throw new bizError_1.BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}
exports.initConfig = initConfig;
//# sourceMappingURL=serverConfig.js.map