"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = void 0;
const zmxfxfbData_1 = require("../data/table/zmxfxfbData");
const inFrontOut_1 = require("../dataPackage/inFrontOut");
const out_1 = require("../dataPackage/out");
/*致命性风险分布*/
function getData(req, res) {
    let line = req.query.line || -1;
    let excelData = zmxfxfbData_1.zmxfxfbTableData();
    let ret = {};
    let zmxfxfbTableDataList = inFrontOut_1.tablePackage(excelData["致命性风险分布"].headerList[0], excelData["致命性风险分布"].bodyList);
    let jk = 0;
    let qj = 0;
    let ptd = 0;
    let 全网 = [];
    let 致命性风险 = [];
    zmxfxfbTableDataList.dataList.forEach(info => {
        let { A, B, C, D } = info;
        if (A != "全网") {
            if (A == line) {
                致命性风险 = [{ key: "基坑", value: B }, { key: "区间", value: C }, { key: "旁通道", value: D }];
            }
            else if (line == -1) {
                jk += parseInt(B);
                qj += parseInt(C);
                ptd += parseInt(D);
                致命性风险 = [{ key: "基坑", value: jk }, { key: "区间", value: qj }, { key: "旁通道", value: ptd }];
            }
        }
        else {
            全网.push({ key: "基坑", value: B }, { key: "区间", value: C }, { key: "旁通道", value: D });
        }
        let zmxfxfbPackageData = { dataInfo: { "全网": 全网, "致命性风险": 致命性风险 }, xUnit: "", yUnit: "" };
        ret['zmxfxfb'] = out_1.getOnceYBarChartOut('致命性风险分布', zmxfxfbPackageData);
    });
    res.send(ret);
}
exports.getData = getData;
//# sourceMappingURL=zmxfxfb.js.map