"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = void 0;
const xxjdData_1 = require("../data/table/xxjdData");
const inFrontOut_1 = require("../dataPackage/inFrontOut");
const out_1 = require("../dataPackage/out");
/*形象进度*/
function getData(req, res) {
    let line = req.query.line || "全部";
    let excelData = xxjdData_1.xxjdTableData();
    let ret = {};
    let xxjdsjTableDataList = inFrontOut_1.tablePackage(excelData["形象进度数据"].headerList[0], excelData["形象进度数据"].bodyList);
    let 车站总数 = [];
    let 盾构机工作台数 = [];
    let 旁通道总数 = [];
    let czzs = 0;
    let dgjzs = 0;
    let ptdzs = 0;
    xxjdsjTableDataList.dataList.forEach(info => {
        let { A, B, C, D } = info;
        if (A == line) {
            车站总数.push({ key: "车站总数", value: B });
            盾构机工作台数.push({ key: "盾构机工作台数", value: C });
            旁通道总数.push({ key: "旁通道总数", value: D });
        }
        else if (line == "全部") {
            czzs = parseInt(B) + czzs;
            dgjzs = parseInt(C) + dgjzs;
            ptdzs = parseInt(D) + ptdzs;
            车站总数 = [{ key: "车站总数", value: czzs }];
            盾构机工作台数 = [{ key: "盾构机工作台数", value: dgjzs }];
            旁通道总数 = [{ key: "旁通道总数", value: ptdzs }];
        }
    });
    let czzsPackageData = inFrontOut_1.keyValuePackage(车站总数);
    ret['czzs'] = out_1.getKeyValueOut('车站总数', czzsPackageData);
    let dgjzsPackageData = inFrontOut_1.keyValuePackage(盾构机工作台数);
    ret['dgjgzts'] = out_1.getKeyValueOut('盾构机工作台数', dgjzsPackageData);
    let ptdzsPackageData = inFrontOut_1.keyValuePackage(旁通道总数);
    ret['ptdzs'] = out_1.getKeyValueOut('旁通道总数', ptdzsPackageData);
    let xxjdxxsjTableDataList = inFrontOut_1.tablePackage(excelData["形象进度详细数据"].headerList[0], excelData["形象进度详细数据"].bodyList);
    let 车站 = [];
    let 盾构机 = [];
    let 旁通道 = [];
    let czxx = 0;
    let dgjxx = 0;
    let ptdxx = 0;
    let czjd = 0;
    let dgjxxjd = 0;
    let ptdxxjd = 0;
    xxjdxxsjTableDataList.dataList.forEach(info => {
        let { A, B, C, D, E } = info;
        if (A == line) {
            switch (B) {
                case '车站':
                    车站.push({ key: C, value: D }, { key: C + "进度", value: E });
                    break;
                case '盾构机':
                    盾构机.push({ key: C, value: D }, { key: C + "进度", value: E });
                    break;
                case '旁通道':
                    旁通道.push({ key: C, value: D }, { key: C + "进度", value: E });
                    break;
            }
        }
        else if (line == "全部") {
            switch (B) {
                case '车站':
                    czxx = parseInt(D) + czxx;
                    czjd = parseInt(E) + czjd;
                    车站 = [{ key: C, value: czxx }, { key: C + "进度", value: czjd }];
                    break;
                case '盾构机':
                    dgjxx = parseInt(D) + dgjxx;
                    dgjxxjd = parseInt(E) + dgjxxjd;
                    盾构机 = [{ key: C, value: dgjxx }, { key: C + "进度", value: dgjxxjd }];
                    break;
                case '旁通道':
                    ptdxx = parseInt(D) + ptdxx;
                    ptdxxjd = parseInt(E) + ptdxxjd;
                    旁通道 = [{ key: C, value: ptdxx }, { key: C + "进度", value: ptdxxjd }];
                    break;
            }
        }
    });
    let czxxsjPackageData = inFrontOut_1.keyValuePackage(车站);
    ret['czxxsj'] = { title: '车站详细数据', dataList: czxxsjPackageData };
    let dgjxxsjPackageData = inFrontOut_1.keyValuePackage(盾构机);
    ret['dgjxxsj'] = { title: '盾构机详细数据', dataList: dgjxxsjPackageData };
    let ptdxxsjPackageData = inFrontOut_1.keyValuePackage(旁通道);
    ret['ptdxxsj'] = { title: '旁通道详细数据', dataList: ptdxxsjPackageData };
    res.send(ret);
}
exports.getData = getData;
//# sourceMappingURL=xxjd.js.map