"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = void 0;
const jhjdData_1 = require("../data/table/jhjdData");
const inFrontOut_1 = require("../dataPackage/inFrontOut");
const out_1 = require("../dataPackage/out");
/*计划进度*/
function getData(req, res) {
    let line = req.query.line || "全部";
    let excelData = jhjdData_1.jhjdTableData();
    let ret = {};
    let jhjdsjTableDataList = inFrontOut_1.tablePackage(excelData["计划进度数据"].headerList[0], excelData["计划进度数据"].bodyList);
    let 证件办理 = [];
    let 动迁 = [];
    let 移交 = [];
    let 年度总计划 = 0;
    let zjbl = 0;
    let dq = 0;
    let yj = 0;
    let zjbljd = 0;
    let dqjd = 0;
    let yjjd = 0;
    let len = jhjdsjTableDataList.dataList.length;
    jhjdsjTableDataList.dataList.forEach(info => {
        let { A, B, C, D, E, F, G } = info;
        if (A == line) {
            证件办理.push({ key: "证件办理", value: B }, { key: "证件办理进度", value: C });
            动迁.push({ key: "动迁", value: D }, { key: "动迁进度", value: E });
            移交.push({ key: "移交", value: F }, { key: "移交进度", value: G });
            // 年度总计划 = B + D + F;
        }
        else if (line == "全部") {
            zjbl = parseInt(B) + zjbl;
            dq = parseInt(D) + dq;
            yj = parseInt(F) + yj;
            zjbljd = parseInt(C) + zjbljd;
            dqjd = parseInt(E) + dqjd;
            yjjd = parseInt(G) + yjjd;
            // 年度总计划 = zjbl + dq + yj;
            证件办理 = [{ key: "证件办理", value: zjbl }, { key: "证件办理进度", value: zjbljd / len }];
            动迁 = [{ key: "动迁", value: dq }, { key: "动迁进度", value: dqjd / len }];
            移交 = [{ key: "移交", value: yj }, { key: "移交进度", value: yjjd / len }];
        }
    });
    // ret['ndzjh'] = {title: "年度总计划", dataList: {key:"年度总计划", value:年度总计划}};
    let zjblPackageData = inFrontOut_1.keyValuePackage(证件办理);
    let zjblJd = getXxsj(zjblPackageData);
    ret['zjbl'] = { title: "证件办理", dataList: zjblJd };
    let dqPackageData = inFrontOut_1.keyValuePackage(动迁);
    let dqJd = getXxsj(dqPackageData);
    ret['dq'] = { title: "动迁", dataList: dqJd };
    let yjPackageData = inFrontOut_1.keyValuePackage(移交);
    let yjJd = getXxsj(yjPackageData);
    ret['yj'] = { title: "移交", dataList: yjJd };
    let jhjdxxsjTableDataList = inFrontOut_1.tablePackage(excelData["计划进度详细数据"].headerList[0], excelData["计划进度详细数据"].bodyList);
    let 证件办理详细 = [];
    let 动迁详细 = [];
    let 移交详细 = [];
    jhjdxxsjTableDataList.dataList.forEach(info => {
        let { A, B, C, D } = info;
        if (A == line) {
            switch (B) {
                case '证件办理':
                    证件办理详细.push({ key: C, value: D });
                    break;
                case '动迁':
                    动迁详细.push({ key: C, value: D });
                    break;
                case '移交':
                    移交详细.push({ key: C, value: D });
                    break;
            }
        }
        else if (line == "全部") {
            switch (B) {
                case '证件办理':
                    证件办理详细.push({ key: C, value: D });
                    break;
                case '动迁':
                    动迁详细.push({ key: C, value: D });
                    break;
                case '移交':
                    移交详细.push({ key: C, value: D });
                    break;
            }
        }
    });
    let zjblxxPackageData = inFrontOut_1.keyValuePackage(证件办理详细);
    ret['zjblxxxl'] = out_1.getKeyValueOut('证件办理详细线路', zjblxxPackageData);
    let dqxxxlPackageData = inFrontOut_1.keyValuePackage(动迁详细);
    ret['dqxxxl'] = out_1.getKeyValueOut('动迁详细线路', dqxxxlPackageData);
    let yjxxxlPackageData = inFrontOut_1.keyValuePackage(移交详细);
    ret['yjxxxl'] = out_1.getKeyValueOut('移交详细线路', yjxxxlPackageData);
    res.send(ret);
}
exports.getData = getData;
function getXxsj(packageData) {
    let result = [];
    packageData[0]["progress"] = packageData[1].value;
    result.push(packageData[0]);
    return result;
}
//# sourceMappingURL=jhjd.js.map