"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = void 0;
const gcaqztData_1 = require("../data/table/gcaqztData");
const inFrontOut_1 = require("../dataPackage/inFrontOut");
const out_1 = require("../dataPackage/out");
/*工程安全状态*/
function getData(req, res) {
    let line = req.query.line || "全部";
    let excelData = gcaqztData_1.gcaqztTableData();
    let ret = {};
    let xxjdsjTableDataList = inFrontOut_1.tablePackage(excelData["风险期数量"].headerList[0], excelData["风险期数量"].bodyList);
    let 基坑风险期数量 = [];
    let 盾构区间风险期数量 = [];
    let 旁通道风险期数量 = [];
    let jkfxqsl = 0;
    let dgqjfxqsl = 0;
    let ptdfxqsl = 0;
    xxjdsjTableDataList.dataList.forEach(info => {
        let { A, B, C, D } = info;
        if (!D)
            D = "-";
        if (A == line) {
            基坑风险期数量.push({ key: "基坑风险期数量", value: B });
            盾构区间风险期数量.push({ key: "盾构区间风险期数量", value: C });
            旁通道风险期数量.push({ key: "旁通道风险期数量", value: D });
        }
        else if (line == "全部") {
            jkfxqsl = parseInt(B) + jkfxqsl;
            dgqjfxqsl = parseInt(C) + dgqjfxqsl;
            if (!D)
                ptdfxqsl = parseInt(D) + ptdfxqsl;
            基坑风险期数量 = [{ key: "基坑风险期数量", value: jkfxqsl }];
            盾构区间风险期数量 = [{ key: "盾构区间风险期数量", value: dgqjfxqsl }];
            旁通道风险期数量 = [{ key: "旁通道风险期数量", value: ptdfxqsl }];
        }
    });
    let jkfxqslPackageData = inFrontOut_1.keyValuePackage(基坑风险期数量);
    ret['jkfxqsl'] = out_1.getKeyValueOut('基坑风险期数量', jkfxqslPackageData);
    let dgqjfxqslPackageData = inFrontOut_1.keyValuePackage(盾构区间风险期数量);
    ret['dgqjfxqsl'] = out_1.getKeyValueOut('盾构区间风险期数量', dgqjfxqslPackageData);
    let ptdfxqslPackageData = inFrontOut_1.keyValuePackage(旁通道风险期数量);
    ret['ptdfxqsl'] = out_1.getKeyValueOut('旁通道风险期数量', ptdfxqslPackageData);
    let zmxfxfbTableDataList = inFrontOut_1.tablePackage(excelData["工程安全状态详细数据"].headerList[0], excelData["工程安全状态详细数据"].bodyList);
    let 基坑 = [];
    let 盾构区间 = [];
    let 旁通道 = [];
    let jkxx = 0;
    let dgqjxx = 0;
    let ptdxx = 0;
    let jkjd = 0;
    let dgqjjd = 0;
    let ptdjd = 0;
    zmxfxfbTableDataList.dataList.forEach(info => {
        let { A, B, C, D, E } = info;
        if (A == line) {
            switch (B) {
                case '基坑':
                    基坑.push({ key: C, value: D }, { key: C + "进度", value: E });
                    break;
                case '盾构区间':
                    盾构区间.push({ key: C, value: D }, { key: C + "进度", value: E });
                    break;
                case '旁通道':
                    旁通道.push({ key: C, value: D }, { key: C + "进度", value: E });
                    break;
            }
        }
        else if (line == "全部") {
            switch (B) {
                case '基坑':
                    jkxx = parseInt(D) + jkxx;
                    jkjd = parseInt(E) + jkjd;
                    基坑 = [{ key: C, value: jkxx }, { key: C + "进度", value: jkjd }];
                    break;
                case '盾构区间':
                    dgqjxx = parseInt(D) + dgqjxx;
                    dgqjjd = parseInt(E) + dgqjjd;
                    盾构区间 = [{ key: C, value: dgqjxx }, { key: C + "进度", value: dgqjjd }];
                    break;
                case '旁通道':
                    ptdxx = parseInt(D) + ptdxx;
                    ptdjd = parseInt(E) + ptdjd;
                    旁通道 = [{ key: C, value: ptdxx }, { key: C + "进度", value: ptdjd }];
                    break;
            }
        }
    });
    let jkxxsjPackageData = inFrontOut_1.keyValuePackage(基坑);
    ret['jkxxsj'] = { title: '基坑详细数据', dataList: jkxxsjPackageData };
    let dgqjxxsjPackageData = inFrontOut_1.keyValuePackage(盾构区间);
    ret['dgqjxxsj'] = { title: '盾构区间详细数据', dataList: dgqjxxsjPackageData };
    let ptdxxsjPackageData = inFrontOut_1.keyValuePackage(旁通道);
    ret['ptdxxsj'] = { title: '旁通道详细数据', dataList: ptdxxsjPackageData };
    res.send(ret);
}
exports.getData = getData;
//# sourceMappingURL=gcaqzt.js.map