"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = void 0;
const dqfxjdData_1 = require("../data/table/dqfxjdData");
const inFrontOut_1 = require("../dataPackage/inFrontOut");
const out_1 = require("../dataPackage/out");
/*当前风险节点*/
function getData(req, res) {
    let line = req.query.line || "全部";
    let excelData = dqfxjdData_1.dqfxjdTableData();
    let ret = {};
    let xxjdsjTableDataList = inFrontOut_1.tablePackage(excelData["当前风险指数"].headerList[0], excelData["当前风险指数"].bodyList);
    let 基坑变形 = [];
    let 地层损失率 = [];
    let 旁通道地表沉降 = [];
    let jkbx = 0;
    let dcssl = 0;
    let ptddbcx = 0;
    xxjdsjTableDataList.dataList.forEach(info => {
        let { A, B, C, D } = info;
        if (!D)
            D = "-";
        if (A == line) {
            基坑变形.push({ key: "基坑变形", value: B });
            地层损失率.push({ key: "地层损失率", value: C });
            旁通道地表沉降.push({ key: "旁通道地表沉降", value: D });
        }
        else if (line == "全部") {
            jkbx = parseInt(B) + jkbx;
            dcssl = parseInt(C) + dcssl;
            if (!D)
                ptddbcx = parseInt(D) + ptddbcx;
            基坑变形 = [{ key: "基坑变形", value: jkbx }];
            地层损失率 = [{ key: "地层损失率", value: dcssl }];
            旁通道地表沉降 = [{ key: "旁通道地表沉降", value: ptddbcx }];
        }
    });
    let jkbxPackageData = inFrontOut_1.keyValuePackage(基坑变形);
    ret['jkbx'] = out_1.getKeyValueOut('基坑变形', jkbxPackageData);
    let dcsslPackageData = inFrontOut_1.keyValuePackage(地层损失率);
    ret['dcssl'] = out_1.getKeyValueOut('地层损失率', dcsslPackageData);
    let ptddbcxPackageData = inFrontOut_1.keyValuePackage(旁通道地表沉降);
    ret['ptddbcx'] = out_1.getKeyValueOut('旁通道地表沉降', ptddbcxPackageData);
    let xxjdxxsjTableDataList = inFrontOut_1.tablePackage(excelData["风险节点数据"].headerList[0], excelData["风险节点数据"].bodyList);
    let 基坑 = [];
    let 区间 = [];
    let 旁通道 = [];
    let jk = 0;
    let qj = 0;
    let ptd = 0;
    let jkdqsl = 0;
    let qjdqsl = 0;
    let ptddqsl = 0;
    xxjdxxsjTableDataList.dataList.forEach(info => {
        let { A, B, C, D } = info;
        if (A == line) {
            switch (B) {
                case '基坑':
                    基坑.push({ key: B + "总数", value: C }, { key: "当前数量", value: D });
                    break;
                case '区间':
                    区间.push({ key: B + "总数", value: C }, { key: "当前数量", value: D });
                    break;
                case '旁通道':
                    旁通道.push({ key: B + "总数", value: C }, { key: "当前数量", value: D });
                    break;
            }
        }
        else if (line == "全部") {
            switch (B) {
                case '基坑':
                    jk = parseInt(C) + jk;
                    jkdqsl = parseInt(D) + jkdqsl;
                    基坑 = [{ key: B + "总数", value: jk }, { key: "当前数量", value: jkdqsl }];
                    break;
                case '区间':
                    qj = parseInt(C) + qj;
                    qjdqsl = parseInt(D) + qjdqsl;
                    区间 = [{ key: B + "总数", value: qj }, { key: "当前数量", value: qjdqsl }];
                    break;
                case '旁通道':
                    ptd = parseInt(C) + ptd;
                    ptddqsl = parseInt(D) + ptddqsl;
                    旁通道 = [{ key: B + "总数", value: ptd }, { key: "当前数量", value: ptddqsl }];
                    break;
            }
        }
    });
    let jkxxsjPackageData = inFrontOut_1.keyValuePackage(基坑);
    ret['jkxxsj'] = { title: '基坑详细数据', dataList: jkxxsjPackageData };
    let qjxxsjPackageData = inFrontOut_1.keyValuePackage(区间);
    ret['qjxxsj'] = { title: '区间详细数据', dataList: qjxxsjPackageData };
    let ptdxxsjPackageData = inFrontOut_1.keyValuePackage(旁通道);
    ret['ptdxxsj'] = { title: '旁通道详细数据', dataList: ptdxxsjPackageData };
    res.send(ret);
}
exports.getData = getData;
//# sourceMappingURL=dqfxjd.js.map