/**
* 在建车站弹窗路由
*/

import * as asyncHandler from 'express-async-handler';
import * as stationInfoBiz from '../biz/stationPopup/stationInfo';
import * as participatingUnitsBiz from '../biz/stationPopup/participatingUnits';
import * as earlyCertificationBiz from '../biz/stationPopup/earlyCertification';
import * as relocationTengdiBiz from '../biz/stationPopup/relocationTengdi';
import * as pipelineRelocationBiz from '../biz/stationPopup/pipelineRelocation';
import * as civilEngineeringBiz from '../biz/stationPopup/civilEngineering';
import * as constructionMilestonesBiz from '../biz/stationPopup/constructionMilestones';
import * as smartConstructionSiteBiz from '../biz/stationPopup/smartConstructionSite';
import * as riskHazardsBiz from '../biz/stationPopup/riskHazards';
import * as constructionMaterialsBiz from '../biz/stationPopup/constructionMaterials';
import * as remainingProblemsBiz from '../biz/stationPopup/remainingProblems';

//constructionMaterials
export function setRouter(httpServer) {
   httpServer.get('/stationpopup/station', asyncHandler(stationInfoBiz.getStation)); //车站信息 4.0

   httpServer.get('/stationpopup/participatingunits', asyncHandler(participatingUnitsBiz.getParticipatingUnits)); //参建单位 4.0

   httpServer.get('/stationpopup/earlycertification', asyncHandler(earlyCertificationBiz.getEarlyCertification)); //前期证照 4.0

   httpServer.get('/stationpopup/relocationtengdi', asyncHandler(relocationTengdiBiz.getRelocationTengdi)); //动迁腾地

   httpServer.get('/stationpopup/pipelinerelocation', asyncHandler(pipelineRelocationBiz.getPipelineRelocation)); //管线搬迁 4.0
   httpServer.get('/stationpopup/pipelinerelocation/details', asyncHandler(pipelineRelocationBiz.getPipelineRelocationDetails)); //管线搬迁详情

   httpServer.get('/stationpopup/civilengineering', asyncHandler(civilEngineeringBiz.getCivilEngineering)); //土建形象进度
   httpServer.get('/stationpopup/civilengineering/details', asyncHandler(civilEngineeringBiz.getCivilEngineeringDetails)); //土建形象进度 工序完成情况

   httpServer.get('/stationpopup/constructionmilestones', asyncHandler(constructionMilestonesBiz.getConstructionMilestones)); //建设里程碑 4.0
   
   httpServer.get('/stationpopup/smartConstructionSite', asyncHandler(smartConstructionSiteBiz.getSmartConstructionSite)); //智慧工地 4.0
   httpServer.get('/stationpopup/smartConstructionSite/gateData', asyncHandler(smartConstructionSiteBiz.getGateData)); //智慧工地 人员实名制 4.0
   httpServer.get('/stationpopup/smartConstructionSite/monitoringData', asyncHandler(smartConstructionSiteBiz.getMonitoringData)); //智慧工地 监测数据

   httpServer.get('/stationpopup/riskHazards', asyncHandler(riskHazardsBiz.getRiskHazards)); //风险预警 4.0
   httpServer.get('/stationpopup/riskHazards/details', asyncHandler(riskHazardsBiz.getRiskHazardsDetails)); //风险预警详情 4.0

   httpServer.get('/stationpopup/constructionMaterials', asyncHandler(constructionMaterialsBiz.getConstructionMaterials)); //建设资料
   httpServer.get('/stationpopup/constructionMaterials/details', asyncHandler(constructionMaterialsBiz.getConstructionMaterialsDetails)); //建设资料详情
   
   httpServer.get('/stationpopup/remainingproblems', asyncHandler(remainingProblemsBiz.getRemainingProblems)); //遗留问题 4.0
   
   // httpServer.get('/stationpopup/localization', asyncHandler(localizationBiz.getLocalization)); //属地化移交 4.0 设计图还没有定内容
}


// export function setRouter(httpServer) {
//    httpServer.get('/stationpopup/station', asyncHandler(stationInfoBiz.getStation)); //车站信息 4.0

//    httpServer.get('/stationpopup/participatingunits', asyncHandler(participatingUnitsBiz.getParticipatingUnits)); //参建单位 4.0

//    httpServer.get('/stationpopup/earlycertification', asyncHandler(earlyCertificationBiz.getEarlyCertification)); //前期证照 4.0

//    httpServer.get('/stationpopup/relocationtengdi', asyncHandler(relocationTengdiBiz.getRelocationTengdi)); //动迁腾地

//    httpServer.get('/stationpopup/pipelinerelocation', asyncHandler(pipelineRelocationBiz.getPipelineRelocation)); //管线搬迁 4.0
//    httpServer.get('/stationpopup/pipelinerelocationDetails', asyncHandler(pipelineRelocationBiz.getPipelineRelocationDetails)); //管线搬迁详情

//    httpServer.get('/stationpopup/civilengineering', asyncHandler(civilEngineeringBiz.getCivilEngineering)); //土建形象进度
//    httpServer.get('/stationpopup/civilengineeringDetails', asyncHandler(civilEngineeringBiz.getCivilEngineeringDetails)); //土建形象进度 工序完成情况

//    httpServer.get('/stationpopup/constructionmilestones', asyncHandler(constructionMilestonesBiz.getConstructionMilestones)); //建设里程碑 4.0
   
//    httpServer.get('/stationpopup/smartConstructionSite', asyncHandler(smartConstructionSiteBiz.getSmartConstructionSite)); //智慧工地 4.0
//    httpServer.get('/stationpopup/smartConstructionSiteGateData', asyncHandler(smartConstructionSiteBiz.getGateData)); //智慧工地 人员实名制 4.0
//    httpServer.get('/stationpopup/smartConstructionSiteMonitoringData', asyncHandler(smartConstructionSiteBiz.getMonitoringData)); //智慧工地 监测数据

//    httpServer.get('/stationpopup/riskHazards', asyncHandler(riskHazardsBiz.getRiskHazards)); //风险预警 4.0
//    httpServer.get('/stationpopup/riskHazardsDetails', asyncHandler(riskHazardsBiz.getRiskHazardsDetails)); //风险预警详情 4.0

//    httpServer.get('/stationpopup/constructionMaterials', asyncHandler(constructionMaterialsBiz.getConstructionMaterials)); //建设资料
//    httpServer.get('/stationpopup/constructionMaterialsDetails', asyncHandler(constructionMaterialsBiz.getConstructionMaterialsDetails)); //建设资料详情
   
//    httpServer.get('/stationpopup/remainingproblems', asyncHandler(remainingProblemsBiz.getRemainingProblems)); //遗留问题 4.0
   
//    // httpServer.get('/stationpopup/localization', asyncHandler(localizationBiz.getLocalization)); //属地化移交 4.0 设计图还没有定内容
// }



