/**
 * 整体概览路由
 */

import * as asyncHandler from 'express-async-handler';
import * as constructionoperationBiz from '../biz/overview/constructionOperation';
import * as milestoneBiz from '../biz/overview/milestone';
import * as economyBiz from '../biz/overview/economy';
import * as greenTravelBiz from '../biz/overview/greenTravel';
import * as leadingPlanningBiz from '../biz/overview/leadingPlanning';
import * as mapBiz from '../biz/overview/map';

export function setRouter(httpServer) {
    httpServer.get('/overview/constructionoperation', asyncHandler(constructionoperationBiz.getOperate));//建设运营
    httpServer.get('/overview/milestone', asyncHandler(milestoneBiz.getMilestone));//里程碑事件&荣誉成果
    httpServer.get('/overview/economy', asyncHandler(economyBiz.getEconomy));//经济产业
    httpServer.get('/overview/greentravel', asyncHandler(greenTravelBiz.getGreenTravel));//绿色出行
    httpServer.get('/overview/leadingplanning', asyncHandler(leadingPlanningBiz.getLeadingPlanning));//引领/规划
    httpServer.get('/overview/map', asyncHandler(mapBiz.getData));//地图
}