/**
 * 建设指挥 路由
 */

import * as asyncHandler from 'express-async-handler';
import * as plannedprogressBiz from '../biz/construct/plannedprogress';
import * as qualityBiz from '../biz/construct/quality';
import * as mapBiz from '../biz/construct/map';
import * as businessfinanceBiz from '../biz/construct/businessFinance';
import * as investBiz from '../biz/construct/invest';
import * as contractWarningBiz from '../biz/construct/contractWarning';
import * as finalAcountsBiz from '../biz/construct/finalAcounts';

export function setRouter(httpServer) {
    /**计划进度指标面板 */
    httpServer.get('/construct/plannedprogress/prophase', asyncHandler(plannedprogressBiz.getProphase) );//证照办理
    httpServer.get('/construct/plannedprogress/relocation', asyncHandler(plannedprogressBiz.getRelocation) );//动迁腾地
    httpServer.get('/construct/plannedprogress/schedule', asyncHandler(plannedprogressBiz.getSchedule) );//建设计划
    // httpServer.get('/construct/plannedprogress/milestone', asyncHandler(plannedprogressBiz.getMilestone) );//里程碑节点完成情况

    /**质量安全指标面板 */
    httpServer.get('/construct/quality/fatality', asyncHandler(qualityBiz.getFatality) );//重大风险分布
    httpServer.get('/construct/quality/risk', asyncHandler(qualityBiz.getRisk) );//当前风险节点
    httpServer.get('/construct/quality/engineering', asyncHandler(qualityBiz.getEngineering) );//工程安全状态
    
    /**投资管控指标面板 弃用 */
    // httpServer.get('/construct/invest/financialestimates', asyncHandler(investBiz.getFinancialestimates) ); //概算总数
    // httpServer.get('/construct/invest/investmentcontrol', asyncHandler(investBiz.getInvestmentcontrol) ); //投控建设
    // httpServer.get('/construct/invest/finalaccounts', asyncHandler(investBiz.getFinalaccounts) ); //决算统计

    /**业财融合指标面板 弃用 */
    // httpServer.get('/construct/businessfinance/invest', asyncHandler(businessfinanceBiz.getInvest) );//投资完成情况
    // httpServer.get('/construct/businessfinance/earlywarning', asyncHandler(businessfinanceBiz.getEarlywarning) );//合同金额预警总览
    // httpServer.get('/construct/businessfinance/detailed', asyncHandler(businessfinanceBiz.getDetailedData) );//合同金额预警总览详细浮窗

    /**地图 */
    httpServer.get('/construct/map', asyncHandler(mapBiz.getMap) ); //4.0
    //地图预警
    // httpServer.get('/construct/map/earlyWarning', asyncHandler(mapBiz.getEarlyWarning) ); //预警信息 4.0
    httpServer.get('/construct/map/earlyWarning', asyncHandler(mapBiz.getSiteCoordinates) ); //站点坐标预警动效 4.0
    // httpServer.get('/construct/map/sitecoordinates', asyncHandler(mapBiz.getSiteCoordinates) ); //站点坐标 4.0
    

    // 3.0 ----------------------------------------
    /**投资管控指标面板 */
    httpServer.get('/construct/businessfinance/estimate', asyncHandler(businessfinanceBiz.getEstimate) ); //概算总数
    httpServer.get('/construct/businessfinance/investmentcompletion', asyncHandler(businessfinanceBiz.getInvestmentCompletion) ); //投资完成情况
    
    /**业财融合指标面板 */
    httpServer.get('/construct/invest', asyncHandler(investBiz.getInvest) );
    /**合同预警弹窗 */
    httpServer.get('/construct/contractwarning/budgetwarning', asyncHandler(contractWarningBiz.getBudgetWarning) ); //三级概算预警详情 暂时舍弃
    httpServer.get('/construct/contractwarning/targetcost', asyncHandler(contractWarningBiz.getTargetCost) ); //线路概算目标成本 暂时舍弃
    httpServer.get('/construct/contractwarning/type', asyncHandler(contractWarningBiz.getType) ); //下拉选择类型 暂时舍弃
    httpServer.get('/construct/contractwarning/detailed', asyncHandler(contractWarningBiz.getDetailed) ); //线路概算详情 暂时舍弃
    httpServer.get('/construct/contractwarning/estimateearlywarning', asyncHandler(contractWarningBiz.getEstimateEarlyWarning) ); //概算预警
    /**决算 */
    httpServer.get('/construct/finalaccounts/estimateearlywarning', asyncHandler(finalAcountsBiz.getEstimateEarlyWarning) ); //概算预警

}




// export function setRouter(httpServer) {
//     /**计划进度指标面板 */
//     httpServer.get('/construct/prophase', asyncHandler(plannedprogressBiz.getProphase) );//证照办理
//     httpServer.get('/construct/relocation', asyncHandler(plannedprogressBiz.getRelocation) );//动迁腾地
//     httpServer.get('/construct/schedule', asyncHandler(plannedprogressBiz.getSchedule) );//建设计划
//     // httpServer.get('/construct/plannedprogress/milestone', asyncHandler(plannedprogressBiz.getMilestone) );//里程碑节点完成情况

//     /**质量安全指标面板 */
//     httpServer.get('/construct/fatality', asyncHandler(qualityBiz.getFatality) );//重大风险分布
//     httpServer.get('/construct/risk', asyncHandler(qualityBiz.getRisk) );//当前风险节点
//     httpServer.get('/construct/engineering', asyncHandler(qualityBiz.getEngineering) );//工程安全状态
    
//     /**投资管控指标面板 弃用 */
//     // httpServer.get('/construct/invest/financialestimates', asyncHandler(investBiz.getFinancialestimates) ); //概算总数
//     // httpServer.get('/construct/invest/investmentcontrol', asyncHandler(investBiz.getInvestmentcontrol) ); //投控建设
//     // httpServer.get('/construct/invest/finalaccounts', asyncHandler(investBiz.getFinalaccounts) ); //决算统计

//     /**业财融合指标面板 弃用 */
//     // httpServer.get('/construct/businessfinance/invest', asyncHandler(businessfinanceBiz.getInvest) );//投资完成情况
//     // httpServer.get('/construct/businessfinance/earlywarning', asyncHandler(businessfinanceBiz.getEarlywarning) );//合同金额预警总览
//     // httpServer.get('/construct/businessfinance/detailed', asyncHandler(businessfinanceBiz.getDetailedData) );//合同金额预警总览详细浮窗

//     /**地图 */
//     httpServer.get('/construct/map', asyncHandler(mapBiz.getMap) ); //4.0
//     //地图预警
//     // httpServer.get('/construct/map/earlyWarning', asyncHandler(mapBiz.getEarlyWarning) ); //预警信息 4.0
//     httpServer.get('/construct/earlyWarning', asyncHandler(mapBiz.getSiteCoordinates) ); //站点坐标预警动效 4.0
//     // httpServer.get('/construct/map/sitecoordinates', asyncHandler(mapBiz.getSiteCoordinates) ); //站点坐标 4.0
    

//     // 3.0 ----------------------------------------
//     /**投资管控指标面板 */
//     httpServer.get('/construct/estimate', asyncHandler(businessfinanceBiz.getEstimate) ); //概算总数
//     httpServer.get('/construct/investmentcompletion', asyncHandler(businessfinanceBiz.getInvestmentCompletion) ); //投资完成情况
    
//     /**业财融合指标面板 */
//     httpServer.get('/construct/invest', asyncHandler(investBiz.getInvest) );
//     /**合同预警弹窗 */
//     httpServer.get('/construct/budgetwarning', asyncHandler(contractWarningBiz.getBudgetWarning) ); //三级概算预警详情 暂时舍弃
//     httpServer.get('/construct/targetcost', asyncHandler(contractWarningBiz.getTargetCost) ); //线路概算目标成本 暂时舍弃
//     httpServer.get('/construct/type', asyncHandler(contractWarningBiz.getType) ); //下拉选择类型 暂时舍弃
//     httpServer.get('/construct/detailed', asyncHandler(contractWarningBiz.getDetailed) ); //线路概算详情 暂时舍弃
//     httpServer.get('/construct/estimateearlywarning', asyncHandler(contractWarningBiz.getEstimateEarlyWarning) ); //概算预警
//     /**决算 */
//     httpServer.get('/construct/finalaccounts', asyncHandler(finalAcountsBiz.getEstimateEarlyWarning) ); //概算预警

// }
