
import { getInterfaceByInterfaceName, initInterfaceData } from "./data/interface/cronJob";
var os = require("os")
import { httpServer } from "./net/http_server";
import { initConfig, systemConfig } from "./config/serverConfig";
import { getToken } from "./middleware/getToken";
import { writeQualityDataInJson } from "./data/interface/writeJson";
const path = require('path');

async function lanuch() {
    await initConfig();
    // initInterfaceData();
    dataInJson();
    httpServer.createServer( systemConfig.port );
    console.log('This indicates that the server is started successfully.');

}

async function dataInJson() {
    let token = await getToken();
    let data = await getInterfaceByInterfaceName("质量安全指标面板", {token});
    let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), "res", 'quality.json');
    writeQualityDataInJson(data, url);
}

lanuch();



function test() {
    
}


