//打包完数据之后的处理

/**
 * recombinationObject 重组对象 在打包完数据后使用 必须是keyvalue之后
 * @param data [{key:key1, value:value1, unit:unit1 }, {key:key2, value:value2, unit:unit2}]
 * @param check {"key2":[{key:"key1", name:""}] }
 * @returns [{key:key1, value:value1, key2:key2, value2:value2}]
 */
 export function recombinationObject(data, checkInfo) {
    let dataMap = {};
    data.forEach(info => {
        let { key } = info;
        dataMap[key] = info;
    });
    let removeKeyMap = {};

    for (let checkKey in checkInfo) {
        let checkList = checkInfo[checkKey];
        checkList.forEach(item => {
            let {key, name} = item;

            removeKeyMap[key] = 1;
            let onceCheck = dataMap[key];
           
            dataMap[checkKey][name] = onceCheck.value;
            dataMap[checkKey][`${name}Unit`] = onceCheck.unit;
        });
    }


    let dataList = [];
    data.forEach(info => {
        let { key } = info;
        if (removeKeyMap[key]) return;
        dataList.push(dataMap[key]);
    });

    return dataList;
}


/**
 * 修改表格数据结构
 * @param titleList 
 * @param dataList 
 * @returns 
 */
export function change(titleList, dataList) {
    let data = [];
    dataList.forEach(subList => {
        let onceData:any = {};
        subList.forEach( (item, index)=> {
            let key = titleList[index];
            onceData[key] = item;
        } );
        data.push(onceData);
    });
    return data;
}


/**
 * 获取单条线路数据
 * @param line 线路 
 * @param data 数据
 * @param conf 配置
 * @returns 
 */
 export function getLineOneData(line, data, conf) {
    let result:any = {};

    data.forEach(item => {
        let dataLine = item.line;

        if (line == dataLine) {
            for (let name = 0; name < conf.length; name++) {
                result[conf[name]] = item[conf[name]];
            }
        }
    });

    return result;
}



/**
 * 单条弹窗数据
 * @param line 线路 
 * @param data 数据
 * @param conf 配置
 * @returns 
 */
export function getPopupOneData(line, data, conf) {
    let result:any = {};

    data.forEach(item => {
        let dataLine = item.line;
        let dataSite = item.site;

        if (line == dataLine) {
            if (!result[dataSite]) result[dataSite] = {};
            
            for (let name = 0; name < conf.length; name++) {
                result[dataSite][conf[name]] = item[conf[name]];
            }
        }
    });

    return result;
}


/**
 * 多条弹窗数据
 * @param line 
 * @param data 
 * @param conf 
 * @returns 
 */
export function getPopupMoreData(line, data, conf) {
    let result:any = {};

    data.forEach(item => {
        let dataLine = item.line;
        let dataSite = item.site;

        let pipelineRelocationData = {};
        if (line == dataLine) {
            if (!result[dataSite]) result[dataSite] = {site:item.site, state:item.state, data:[]};

            for (let name = 0; name < conf.length; name++) {
                pipelineRelocationData[conf[name]] = item[conf[name]];
            }
            result[dataSite]["data"].push(pipelineRelocationData);
        }
    });

    return result;
}


/**
 * 弹窗详细数据
 * @param id 
 * @param tableData 
 * @param changeConf 
 * @param conf 
 * @returns 
 */
export function getPopupDetailsData(id, tableData, changeConf, conf, name) {
    let details:any = {};

    for (let key in tableData) {
        if (id == key) {
            let data = change(changeConf, tableData[key].bodyList );
        
            data.forEach(item => {
                let itemName = item[name];

                let detailsData = {};
                if (!details[itemName]) details[itemName] = [];

                for (let name = 0; name < conf.length; name++) {
                    detailsData[conf[name]] = item[conf[name]];
                }
                details[itemName].push(detailsData);
            });

        }
    }

    let detailsList = [];
    for (let key in details) {
        detailsList.push({name: key, dataList: details[key]})
    }

    return detailsList;
}