/**
 * 投资管控
 */

import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}


export function contractWarningTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '用款执行');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["用款执行数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function estimateEarlyWarningTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '合同预警');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["概算预警"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function finalAcountsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '决算');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["概算预警"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function budgetwarningTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '三级概算预警');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["三级概算预警"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function targetcostTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '线路概算');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    
    let decollatePlanarList = []; //适配 表格 21号线一期1
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function detailedTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '概算详情');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    
    let decollatePlanarList = []; //适配 表格
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


