/**
 * 业财融合
 */

import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}


export function estimateTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/业财融合.xlsx', '概算总数');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["概算总数数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;     
}


export function investmentStatusTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/业财融合.xlsx', '投资完成情况');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["年度投资情况数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;     
}


export function planningPeriodTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/业财融合.xlsx', '规划期对应线路');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["规划期类型对应线路"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}