/**
 * 在建车站弹窗
 */

import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }
    return result;
}


export function stationTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '车站信息');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["车站信息数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function participatingUnitsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '参建单位');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["参建单位数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function earlyCertificationTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '前期证照');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["前期证照数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function relocationTengdiTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '动迁腾地');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["动迁腾地数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function pipelineRelocationTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '管线搬迁');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["管线搬迁数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function pipelineRelocationDetailsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '管线搬迁详情');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];

    let decollatePlanarList = []; //适配 表格
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })
    
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function civilEngineeringTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '土建形象进度');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["土建形象进度数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function civilEngineeringDetailsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '土建形象进度工序完成情况');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];

    let decollatePlanarList = []; //适配 表格
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function constructionMilestonesTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '建设里程碑');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["建设里程碑数据",];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function smartConstructionSiteTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '智慧工地');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["智慧工地数据", "监测数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function surveillanceVideoTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '智慧工地监控视频');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];

    let decollatePlanarList = []; //适配 表格
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function gateDataTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '智慧工地闸机数据');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];

    let decollatePlanarList = []; //适配 表格
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function monitoringDataTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '智慧工地监测数据');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];

    let decollatePlanarList = []; //适配 表格
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function riskHazardsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '风险隐患');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["风险隐患数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function riskHazardsDetailsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '风险隐患详情');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];

    let decollatePlanarList = []; //适配 表格
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function constructionMaterialsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '建设资料');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["建设资料数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function constructionMaterialsDetailsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '建设资料详情');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];

    let decollatePlanarList = []; //适配 表格
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function remainingProblemsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('在建车站弹窗/在建车站.xlsx', '遗留问题');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["遗留问题数据"];//适配 表格

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


