/**
 * 整体建设概览
 */

import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function jsyyTableData() {
    let blockDataList = onceSheetBecomeOfblockData('整体建设概览/整体建设概览.xlsx', '建设运营');

    let keyValueOrTitleList = ["基础数据","工程建设","全面创优","专业设施设备","建设进度","建设进度占比","质量","质量合格率","各项目验收达标情况","安全","风险分布","安全处置数据","监测数据异常超标", "各线路建设进度汇总目标值"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["各线路建设进度汇总"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;  
}


export function lcbsjTableData() {
    let blockDataList = onceSheetBecomeOfblockData('整体建设概览/整体建设概览.xlsx', '里程碑事件荣誉成果');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["里程碑事件", "荣誉成果"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function jjcyTableData() {
    let blockDataList = onceSheetBecomeOfblockData('整体建设概览/整体建设概览.xlsx', '经济产业');

    let keyValueOrTitleList = ["基础数据", "全国GDP", "上海GDP"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["上海地铁投资建设占上海GDP变化趋势", "地铁开通前后区域价格变化趋势"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;   
}


export function lscxTableData() {
    let blockDataList = onceSheetBecomeOfblockData('整体建设概览/整体建设概览.xlsx', '绿色出行');

    let keyValueOrTitleList = ["出行方式占比", "绿色节能", "地铁节能减排趋势"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function ylghTableData() {
    let blockDataList = onceSheetBecomeOfblockData('整体建设概览/整体建设概览.xlsx', '引领规划');

    let keyValueOrTitleList = ["城市规划", "轮播图"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["未来规划"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}


export function dtTableData() {
    let blockDataList = onceSheetBecomeOfblockData('整体建设概览/整体建设概览.xlsx', '地图');

    let keyValueOrTitleList = ["基础数据", "历年建设里程列表"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}