/**
 * 建设指挥平台
 */

import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}


export function prophaseTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/计划进度.xlsx', '前期管理');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["前期管理数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}


export function relocationTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/计划进度.xlsx', '动迁腾地');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["概览数据", "动迁腾地详细"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}


export function scheduleTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/计划进度.xlsx', '建设计划');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["建设计划数据", "详细数据1", "详细数据2", "详细数据3", "详细数据4", "详细数据5", "详细数据6"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function milestoneTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/计划进度.xlsx', '里程碑节点完成情况');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["里程碑节点完成情况"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
     
}


export function fatalityTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/质量安全.xlsx', '质量安全');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["旁通道", "基坑", "盾构区间"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}


export function riskTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/质量安全.xlsx', '质量安全');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["风险详细"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}


export function financialestimatesTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '概算总数');

    let keyValueOrTitleList = ["2021总线路", "2022总线路", "2023总线路", "2021各线路概算金额", "2022各线路概算金额", "2023各线路概算金额"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;     
}


export function investmentcontrolTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '投控建设');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = ["2021投控建设", "2022投控建设", "2023投控建设"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function finalaccountsTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/投资管控.xlsx', '决算统计');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的

    let barChartList = ["2023合同数据", "2023合同决算统计", "2023业务系统数"]; //适配 柱状图 折线图 

    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
     
}


export function investTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/业财融合.xlsx', '投资完成情况');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["投资完成情况"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}


export function earlywarningTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/业财融合.xlsx', '合同金额预警总览');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["崇明线", "19号线", "17号线", "23号线", "21号线"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}


export function earlywarningDetailTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/业财融合.xlsx', '合同金额预警总览浮窗数据');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["车站", "区间", "轨道", "通讯", "信号", "供电", "综合监控"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}


export function mapTableData() {
    let blockDataList = onceSheetBecomeOfblockData(`建设指挥平台/建设指挥平台地图.xlsx`, '地图');

    let keyValueOrTitleList = ["基础数据"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["线路列表"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function mapLineTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/建设指挥平台地图.xlsx', '地图线路');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["地图线路"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function lineConstructTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/建设指挥平台地图.xlsx', '建设里程碑');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    
    let decollatePlanarList = []; //适配 表格 2号线西延伸
    blockDataList.forEach( item => {
        let {blockData, blockTitle} = item;
        decollatePlanarList.push(blockTitle);
    })

    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function mapSiteTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/建设指挥平台地图.xlsx', '站点坐标');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["2号线西延伸", "17号线", "18号线二期", "19号线", "21号线", "23号线", "崇明线"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function mapSiteJsonTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台/建设指挥平台地图.xlsx', '坐标json');

    let keyValueOrTitleList = ["坐标json数据"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}

