import moment = require("moment");
import { broadcastMsg } from "../../biz/wsData";
import { systemConfig } from "../../config/serverConfig";
import { logHandle } from "../../util/log";

export let vehicleLocData = [];

let lockReconnect = false;

async function reconnect() {
    if(lockReconnect) return;

    lockReconnect = true;
    await sleep(5 * 1000);
    createSocket();
}

async function sleep(ms) {
    return new Promise((resolve, reject)=>{
        setTimeout(async function () {   
            resolve(true);
        }, ms);
    })
}


let heartCount = 0;
//心跳
let heart = {
    timeout:10*1000,//10秒一次心跳包
    timeoutObj:null,
    reconnectTimeout:5 * 1000, //重连延迟
    start:(ws) => {
        if (!heartCount) {
            heartCount = 1;
        }
        
        heart.timeoutObj && clearInterval(heart.timeoutObj);


        heart.timeoutObj = setInterval( () => {
            //发送心跳包
            console.log("本机call目标服务 发送心跳包");
            ws.send("i am heart");
        }, heart.timeout);
    },

    reset: () => {//重置
        clearInterval(heart.timeoutObj);
    }
}


//ws客户端
async function createSocket() {
    console.log(systemConfig.wsPath);
    let ws = new WebSocket(systemConfig.wsPath);

    ws.onclose = async (err) => {
        console.log("连接关闭: ", err);
        lockReconnect = false;
        heartCount = 0;
        heart.reset();
        //断线重连
        reconnect();
    }

    ws.onmessage = (msg) => {
        //接收数据
        stats(msg.data);
    }

    ws.onerror = (error) => {
        ws.close();
    }

    ws.onopen = () => {
        heart.start(ws);
    }
    console.log(`连接汽车数据socket服务： ${systemConfig.wsPath} 成功`);
}


export async function initWSData() {
    await createSocket();
}

//在线车辆
let dp = {};//数据池 {"id":{lastMs:最新的时间, list:[{},{},{}], index:0 } }
let dpNewDate = '';


//结构：{"vid":{s:{lng:, lat:''}, e:{}, t:"" , lastCheckMs:0,}}
let test = {};
// let  = 0;

//模式缓存
let driveModeQueue = {};//{"vid":{driveMode, velocity}}
export function getDriveModeAndVelocity(vin) {
    if (!driveModeQueue[vin]) return {driveMode:"人工", velocity:"0公里/小时"};
    return {
        driveMode:driveModeQueue[vin].driveMode == 1? "自动":"人工",
        velocity:`${Math.round(driveModeQueue[vin].velocity)}公里/小时`
    }
}


export function stats(data) {
    let dateFormat = moment().format('YYYYMMDD');
    if (!dpNewDate) dpNewDate = dateFormat;

    if (typeof data == "string") {
        try{
            // console.log(data);
            let dataJson = JSON.parse(data);

            if (dataJson.VehicleLoc) {
                let {vin, latitude, longitude, positionTime, driveMode, vehicleId, velocity, daymileage, dayduration, totalMileage, totalDuration} = dataJson.VehicleLoc;
                vehicleLocData.push({vin, daymileage, dayduration, totalMileage, totalDuration}); //当日实时测试里程，当日实时测试时长，累计测试里程，累计测试时长
                // console.log("收到小车位置", vin);
                // broadcastMsg({lng:longitude||0.0, lat:latitude||0.0, vin, vehicleid:vehicleId});
                //加入到缓存
                let lastMs = positionTime || new Date().valueOf();
                if ( lastMs ) {//数据包里有时间就缓存
                    checkData(dateFormat);
                    if ( !dp[vin] )  dp[vin] = {lastMs, list:[], index:0 };//初始化缓存
                    //每个小车缓存4个数据，新连接进来的时候下发缓存好的数据，看起来不会很突兀
                    dp[vin].list[dp[vin].index] = {lng:longitude||0.0, lat:latitude||0.0, vin, lastMs, vehicleid:vehicleId};
                    dp[vin].index += 1;
                    if (dp[vin].index > 4) dp[vin].index = 0;

                    driveModeQueue[vin] = {velocity, driveMode};

                    //==测试代码
                    if (!positionTime) return;
                    if (!test[vin] ) test[vin] = {s:{lng:longitude||0.0, lat:latitude||0.0}, e:{lng:0, lat:0}, st:positionTime, et:0, lastCheckMs:new Date().valueOf()};

                    if ( ( new Date().valueOf() - test[vin].lastCheckMs ) >= 1000) {
                        if ( !test[vin].et ) {
                            //初始车
                            test[vin].e = {lng:longitude||0.0, lat:latitude||0.0};
                        } else {
                            //非初始车
                            test[vin].s = test[vin].e;
                            test[vin].st = test[vin].et;
                            test[vin].e = {lng:longitude||0.0, lat:latitude||0.0};
                        }
                        test[vin].et = positionTime;
                        test[vin].t = test[vin].et - test[vin].st;
                        test[vin].lastCheckMs = new Date().valueOf();
                        //发送消息给小车
                        broadcastMsg(test[vin]);
                    }

                    //==测试代码结束
                }
            }


        } catch(err) {
            logHandle("ws 返回数据不是json  --> "+ data);
        }   
    } else {
        logHandle(`ws 返回数据不符合规范 类型:${typeof data} --> `+ data)
    }
    
}


function checkData(time) {
    if (time != dpNewDate) {
        dpNewDate = time;
        dp = {};
    }   
}

export function getDpData() {
    let result = [];
    for (let key in dp) {
        dp[key].list.forEach(info => {
            result.push(info);
        });
    }
    result.sort( (a, b) => {return a.lastMs - b.lastMs});
    let initList = [];
    result.forEach(info => {
        let {lng, lat, vehicleid, vin, lastMs} = info; 
        initList.push({lng, lat, vin});
    });
    return {initList, count:Object.keys(dp).length};
}

export function getOnlieCarCount() {
    return Object.keys(dp).length;
}

//控制端获取在线小车列表
//最后在线时间如果大于1分钟，判定为下线，不下发到控制端的小车列表里
export function controlGetOnlieCarList() {
    let ms = new Date().valueOf();
    let onlineCarList = [];
    for (let key in dp) {
        let {lastMs, list, index} = dp[key];
        if ((ms -lastMs) > 1*60*1000) continue;
        if (index == 0) continue;
        let {vin, vehicleid} = list[index-1];
        onlineCarList.push({id:vin, vehicleid});
    }
    return onlineCarList;
}
