/**
 * 质量安全指标面板接口数据写入json文件
 */

import { BizError } from "../../util/bizError";

const fs = require('fs');
// const path = require('path');
// const url = path.join(__dirname.substring(0,__dirname.indexOf("out")), "res", 'quality.json');

/**
 * 写入json文件
 * @param data 
 */
export function writeQualityDataInJson(data, url) {
    let str = JSON.stringify(data, null, "\t");
    fs.writeFileSync(url, str, function(err) {
        if (err) {
            throw new BizError(err);
        }
        console.log("写入成功");
    });

}


/**
 * 读取json文件
 */
export function readQualityData(url) {
    let person = JSON.parse(fs.readFileSync(url));
    if (!person) throw new BizError("读取文件数据失败");
    return person;
}


/**
 * 读取文件夹里所有的json文件
 */
 export function readFolderData(url) {
    let files = fs.readdirSync(url);
    if (!files) throw new BizError("获取文件夹数据失败");
    return files;
}


/**
 * 读取文件然后在原有文件内容的基础上添加内容，如果key名重复则覆盖
 */
function addData(data, url) {
    fs.readFile(url, "utf-8", function (err, data) {
        if (err) {
            console.log(err);
        }
        let person = JSON.parse(data);
        Object.assign(data, person);
        let str = JSON.stringify(person, null, "\t");
        fs.writeFile(url, str, function (err) {
            if (err) {
                console.error(err);
            }
            console.log('新增成功!');
        })
    })
}