/**
 * 质量安全指标面板
 * 已对接申电云方接口
 * 由于部署服务器与申电云接口不通，所以本机获取申电云方接口，存入res/quality.json文件，部署服务器上直接读取res/quality.json文件
 */

import { BizError } from "../../util/bizError";
import { readQualityData } from "./writeJson";
const path = require('path');

let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), "res", 'quality.json');

export async function getQualitySafetyPanel() {
    let data = await readQualityData(url);
    // let data = await getInterfaceByInterfaceName("质量安全指标面板暂存json接口", {});

    if (!data) throw new BizError("获取json数据失败");
    let qualitySafetyPanelData = getData(data);

    let significantRisk:any = {"全网":{}}; //重大风险分布

    let currentRisk:any = {}; //当前风险节点
    let currentRiskDetail:any = {};//当前风险节点详细数据

    qualitySafetyPanelData.forEach( item => {
        let {riskFlag, lineName, sectionType, riskLevel, outShapeValue, bottomLoseRate, dbcjVariable, safeStatus} = item;

            /**
            * 重大风险分布
            */
            if (lineName != "全线网") {
                if (!significantRisk[lineName]) significantRisk[lineName] = {};
                if (sectionType != "特大桥") {
                    if (!significantRisk[lineName][sectionType]) significantRisk[lineName][sectionType] = {level1MajorRisks:0, riskTotal:0, secure:0, control:0, focus:0};
                    if (!significantRisk[lineName]["基坑"]) significantRisk[lineName]["基坑"] = {level1MajorRisks:0, riskTotal:0, secure:0, control:0, focus:0};
                    if (!significantRisk[lineName]["旁通道"]) significantRisk[lineName]["旁通道"] = {level1MajorRisks:0, riskTotal:0, secure:0, control:0, focus:0};
                    if (!significantRisk[lineName]["区间"]) significantRisk[lineName]["区间"] = {level1MajorRisks:0, riskTotal:0, secure:0, control:0, focus:0};
                    
                    if (!significantRisk["全网"][sectionType]) significantRisk["全网"][sectionType] = {level1MajorRisks:0, riskTotal:0, secure:0, control:0, focus:0};
                    if (!significantRisk["全网"]["基坑"]) significantRisk["全网"]["基坑"] = {level1MajorRisks:0, riskTotal:0, secure:0, control:0, focus:0};
                    if (!significantRisk["全网"]["旁通道"]) significantRisk["全网"]["旁通道"] = {level1MajorRisks:0, riskTotal:0, secure:0, control:0, focus:0};
                    if (!significantRisk["全网"]["区间"]) significantRisk["全网"]["区间"] = {level1MajorRisks:0, riskTotal:0, secure:0, control:0, focus:0};

                    if (riskLevel == "一级重大风险") { //一级重大风险
                        significantRisk[lineName][sectionType].level1MajorRisks = significantRisk[lineName][sectionType].level1MajorRisks + 1;
                        significantRisk["全网"][sectionType].level1MajorRisks = significantRisk["全网"][sectionType].level1MajorRisks + 1;
                    }
                    if (riskLevel == "一级" || riskLevel == "二级" || riskLevel == "三级" || riskLevel == "一级重大风险") { //风险总数
                        significantRisk[lineName][sectionType].riskTotal = significantRisk[lineName][sectionType].riskTotal + 1; 
                        significantRisk["全网"][sectionType].riskTotal = significantRisk["全网"][sectionType].riskTotal + 1;
                    }
                }
            }

            /**
             * 当前风险节点
             */

            /**基础数据 */
            if (!currentRisk[lineName]) currentRisk[lineName] = {outShapeValue:0, bottomLoseRate:0, dbcjVariable:0};
            currentRisk[lineName].outShapeValue = outShapeValue || 0;
            currentRisk[lineName].bottomLoseRate = bottomLoseRate || 0;
            currentRisk[lineName].dbcjVariable = dbcjVariable || 0;

        if (riskFlag) {
            /**
             * 当前风险节点
             */

            /**详细数据 */
            if (!currentRiskDetail[lineName]) currentRiskDetail[lineName] = {pit:0, interval:0, superMajorBridge:0, pitCount:0, intervalCount:0, superMajorBridgeCount:0};
            if (!currentRiskDetail["全网"]) currentRiskDetail["全网"] = {pit:0, interval:0, superMajorBridge:0, pitCount:0, intervalCount:0, superMajorBridgeCount:0};
            switch(sectionType) {
                case "基坑":
                    currentRiskDetail[lineName].pit = currentRiskDetail[lineName].pit + 1;
                    currentRiskDetail["全网"].pit = currentRiskDetail["全网"].pit + 1;

                    currentRiskDetail[lineName].pitCount = significantRisk[lineName][sectionType].riskTotal;
                    currentRiskDetail["全网"].pitCount = significantRisk["全网"][sectionType].riskTotal;
                break;
                case "区间":
                    currentRiskDetail[lineName].interval = currentRiskDetail[lineName].interval + 1;
                    currentRiskDetail["全网"].interval = currentRiskDetail["全网"].interval + 1;

                    currentRiskDetail[lineName].intervalCount = significantRisk[lineName][sectionType].riskTotal;
                    currentRiskDetail["全网"].intervalCount = significantRisk["全网"][sectionType].riskTotal;
                break;
                case "旁通道":
                    currentRiskDetail[lineName].superMajorBridge = currentRiskDetail[lineName].superMajorBridge + 1;
                    currentRiskDetail["全网"].superMajorBridge = currentRiskDetail["全网"].superMajorBridge + 1;

                    currentRiskDetail[lineName].superMajorBridgeCount = significantRisk[lineName][sectionType].riskTotal;
                    currentRiskDetail["全网"].superMajorBridgeCount = significantRisk["全网"][sectionType].riskTotal;
                break;
            }
            
            /**
             * 工程安全状态
             */
            switch(safeStatus) {
                case '安全':
                    significantRisk[lineName][sectionType].secure = significantRisk[lineName][sectionType].secure + 1;
                    significantRisk["全网"][sectionType].secure = significantRisk["全网"][sectionType].secure + 1;
                break;
                case '风险可控':
                    significantRisk[lineName][sectionType].control = significantRisk[lineName][sectionType].control + 1;
                    significantRisk["全网"][sectionType].control = significantRisk["全网"][sectionType].control + 1;
                break;
                case '重点关注':
                    significantRisk[lineName][sectionType].focus = significantRisk[lineName][sectionType].focus + 1;
                    significantRisk["全网"][sectionType].focus = significantRisk["全网"][sectionType].focus + 1;
                break;
            }

        }
        
    })

    let result:any = {};
    result["significantRisk"] = significantRisk;
    result["currentRisk"] = currentRisk;

    result["currentRiskDetail"] = currentRiskDetail;

    return result;
}


function getData(data) {
    let {success, message, code, timestamp, result, requestId} = data;
    if (success) {
        return result;
    } else {
        throw new BizError(`${code} ${message} 获取接口数据失败`);
    }
}