/**
 * 前期管理
 */
export const ProphaseDefault = {
    total: 0,
    data: {
        "单体规划建设方案": { plan: 0, complete: 0 },
        "单体建设用地规划许可证": { plan: 0, complete: 0 },
        "单体建设工程规划许可证": { plan: 0, complete: 0 },
        "单体施工许可证": { plan: 0, complete: 0 }
    }
};


/**
 * 动迁腾地  completionStatus
 */
 export const CompletionStatusDefault = {
    "total": 0,
    "complete": 0,
    "incomplete": 0
};


/**
 * 动迁腾地 详行政区计划 scheduleList
 */
export const ScheduleListDefault = [
    {
        "name": "",
        "dataList": {
            "total": 0,
            "complete": 0,
            "incomplete": 0
        }
    }
];


/**
 * 形象进度 scheduleList
 */
export const ScheduleDefault = {
    data: {
        "车站": { plan: 0, complete: 0, inProgress: 0, unit: "" },
        "车辆基站": { plan: 0, complete: 0, inProgress: 0, unit: "" },
        "高架区间": { plan: 0, complete: 0, inProgress: 0, unit: "" }
    }
}


/**
 * 形象进度 详细数据  czDetailedData、cljdDetailedData、gjqjDetailedData
 */
export const ScheduleDetailed = {
    data: {
        "1月": { plan: 0, complete: 0 },
        "2月": { plan: 0, complete: 0 },
        "3月": { plan: 0, complete: 0 },
        "4月": { plan: 0, complete: 0 },
        "5月": { plan: 0, complete: 0 },
        "6月": { plan: 0, complete: 0 }
    }
}


/**
 * 合同金额预警总览
 */
export const EarlywarningDefault = [
    ["车站", 0, 0, 0],
    ["区间", 0, 0, 0],
    ["轨道", 0, 0, 0],
    ["通讯", 0, 0, 0],
    ["信号", 0, 0, 0],
    ["供电", 0, 0, 0],
    ["综合监控", 0, 0, 0],
    ["总数", 0, 0, 0],
]


/**
 * 合同金额预警总览详细浮窗
 */
export const EarlywarningDetail = {
    "高架区间": { "accumulatedSignedContractValue": 0, "estimated": 0, "budgetDifference": 0, "targetCost": 0, "targetDifference": 0 },
    "通道区间": { "accumulatedSignedContractValue": 0, "estimated": 0, "budgetDifference": 0, "targetCost": 0, "targetDifference": 0 },
    "出入场线": { "accumulatedSignedContractValue": 0, "estimated": 0, "budgetDifference": 0, "targetCost": 0, "targetDifference": 0 },
    "总计": { "accumulatedSignedContractValue": 0, "estimated": 0, "budgetDifference": 0, "targetCost": 0, "targetDifference": 0 }
};


/**
 * 决算统计 api1
 */
export const FinalaccountsDefault = {
    name: '',
    data: [
        { key: '', value: 0 }
    ]
}


/**
 * 决算统计 api2
 */
export const ContractTypeDefault = {
    name: '',
    data: []
}


/**
 * 决算统计 api3
 */
export const BusinessDefault = {
    name: '',
    data: [
        { key: '咨询类', value: 0 },
        { key: '科研类', value: 0 },
        { key: '监理类', value: 0 },
        { key: '其他类', value: 0 },
        { key: '勘查类', value: 0 },
        { key: '前期类', value: 0 },
        { key: '设计类', value: 0 },
        { key: '工程类', value: 0 }
    ]
}


/**
 * 建设指挥平台地图
 */
export const mapDefault = {
    title: '线路列表',
    dataList: [
        {
            name: '2号线西延伸', value: 35, key: "2号线",
            ygLine: "yg_line2x",
            lineLocation: {
                lng: -17428.174,
                lat: -9858.669,
                height: 3520.564,
                heading: 0.03386971261178928,
                pitch: -0.6624057821120379,
                roll: 6.283185307179565
            },
            lineList: [
                {
                    line: '蟠祥路站',
                    location: {
                        lng: -17798.682,
                        lat: -6326.961,
                        height: 414.915,
                        heading: 0.03386971261177152,
                        pitch: -0.6624057821120575,
                        roll: 6.283185307179565
                    },
                },
            ]
        },
        {
            name: '17号线', value: 35, key: "17号线",
            ygLine: "yg_line17",
            lineLocation: {
                lng: -46787.422,
                lat: -28797.762,
                height: 9928.764,
                heading: 0.03386971261170757,
                pitch: -0.6624057821120424,
                roll: 7.194245199571014e-14
            },
            lineList: [
                {
                    line: '西岑站',
                    location: {
                        lng: -48442.743,
                        lat: -18969.986,
                        height: 866.211,
                        heading: 0.043056449962152854,
                        pitch: -0.6649790172211736,
                        roll: 7.638334409421077e-14
                    }
                },
            ]
        },
        {
            name: '18号线二期', value: 35, key: "18号线",
            ygLine: "yg_line18",
            lineLocation: {
                lng: -2173.224,
                lat: -1970.453,
                height: 11287.685,
                heading: 0.03386971261171112,
                pitch: -0.6624057821119615,
                roll: 6.394884621840902e-14
            },
            lineList: [
                {
                    line: '大康路站',
                    location: {
                        lng: -5009.113,
                        lat: 11230.428,
                        height: 40.848,
                        heading: 0.033869712611719116,
                        pitch: -0.662405782111958,
                        roll: 6.039613253960852e-14
                    }
                },
                {
                    line: '呼兰路站',
                    location: {
                        lng: -3425.366,
                        lat: 11330.769,
                        height: 337.665,
                        heading: 0.03386971261170757,
                        pitch: -0.6624057821119642,
                        roll: 8.970602038971265e-14
                    }
                },
                {
                    line: '爱辉路站',
                    location: {
                        lng: -2147.80,
                        lat: 12127.198,
                        height: 101.281,
                        heading: 0.03386971261168359,
                        pitch: -0.6624057821118234,
                        roll: 1.1812772982011666e-13
                    }
                },
                {
                    line: '江杨南路站',
                    location: {
                        lng: -519.502,
                        lat: 12769.877,
                        height: 125.112,
                        heading: 0.03386971261165428,
                        pitch: -0.6624057821117382,
                        roll: 1.2523315717771766e-13
                    }
                },
                {
                    line: '长江西路站',
                    location: {
                        lng: 336.266,
                        lat: 12141.313,
                        height: 226.682,
                        heading: 0.03386971261164895,
                        pitch: -0.6624057821117257,
                        roll: 1.2878587085651816e-13
                    }
                },
                {
                    line: '通南路站',
                    location: {
                        lng: 764.066,
                        lat: 11262.093,
                        height: 222.821,
                        heading: 0.033869712611650726,
                        pitch: -0.662405782111716,
                        roll: 1.2967404927621828e-13
                    }
                },
                {
                    line: '长江南路站',
                    location: {
                        lng: 1734.032,
                        lat: 10662.784,
                        height: 187.047,
                        heading: 0.0338697126116525,
                        pitch: -0.6624057821117257,
                        roll: 1.305622276959184e-13
                    }
                }
            ]

        },
        {
            name: '19号线', value: 35, key: "19号线",
            ygLine: "",
            lineLocation: {
                lng: -1549.759,
                lat: -108646.927,
                height: 87338.106,
                heading: 0.03386971261170313,
                pitch: -0.6624057821120357,
                roll: 7.72715225139109e-14
            },
            lineList: [
                {
                    line: '虹建路站',
                    location: {
                        lng: -2594.739,
                        lat: -17635.331,
                        height: 743.591,
                        heading: 0.04640137739189143,
                        pitch: -0.5795598363240959,
                        roll: 7.815970093361102e-14
                    }
                },
                {
                    line: '联曹路站',
                    location: {
                        lng: -2757.216,
                        lat: -16114.364,
                        height: 651.092,
                        heading: 0.04640137739188699,
                        pitch: -0.5795598363240924,
                        roll: 8.43769498715119e-14
                    }
                },
                {
                    line: '华泾西站',
                    location: {
                        lng: -2954.063,
                        lat: -14113.684,
                        height: 394.751,
                        heading: 0.04640137739188788,
                        pitch: -0.5795598363240821,
                        roll: 8.43769498715119e-14
                    }
                },
                {
                    line: '华泾路站',
                    location: {
                        lng: -1579.158,
                        lat: -13014.855,
                        height: 300.572,
                        heading: 0.04640137739189232,
                        pitch: -0.579559836324083,
                        roll: 8.171241461241152e-14
                    }
                },
                {
                    line: '三林南站',
                    location: {
                        lng: 1528.711,
                        lat: -13070.450,
                        height: 801.476,
                        heading: 0.04640137739188077,
                        pitch: -0.5795598363240835,
                        roll: 8.348877145181177e-14
                    }
                },
                {
                    line: '凌兆新村站',
                    location: {
                        lng: 1436.576,
                        lat: -10923.304,
                        height: 426.674,
                        heading: 0.04640137739187988,
                        pitch: -0.5795598363240879,
                        roll: 8.43769498715119e-14
                    }
                },
                {
                    line: '东方体育中心站',
                    location: {
                        lng: 886.653,
                        lat: -9060.376,
                        height: 335.937,
                        heading: 0.04640137739187544,
                        pitch: -0.5795598363240879,
                        roll: 8.970602038971265e-14
                    }
                },
                {
                    line: '德州路站',
                    location: {
                        lng: 569.163,
                        lat: -8569.366,
                        height: 608.84,
                        heading: 0.04640137739187189,
                        pitch: -0.5795598363240875,
                        roll: 9.237055564881302e-14
                    }
                },
                {
                    line: '后滩站',
                    location: {
                        lng: 185.793,
                        lat: -7116.977,
                        height: 385.845,
                        heading: 0.04640137739186834,
                        pitch: -0.5795598363240906,
                        roll: 8.615330671091215e-14
                    }
                },
                {
                    line: '世博大道站',
                    location: {
                        lng: 944.969,
                        lat: -6214.413,
                        height: 279.277,
                        heading: 0.04640137739184702,
                        pitch: -0.5795598363240915,
                        roll: 8.79296635503124e-14
                    }
                },
                {
                    line: '世博站',
                    location: {
                        lng: 2367.252,
                        lat: -6120.130,
                        height: 380.038,
                        heading: 0.04640137739185057,
                        pitch: -0.5795598363240941,
                        roll: 8.704148513061227e-14
                    }
                },
                {
                    line: '华丰路站',
                    location: {
                        lng: 3251.686,
                        lat: -5278.735,
                        height: 379.6,
                        heading: 0.04640137739184702,
                        pitch: -0.579559836324091,
                        roll: 9.592326932761353e-14
                    }
                },
                {
                    line: '南码头路站',
                    location: {
                        lng: 3595.207,
                        lat: -4657.705,
                        height: 392.442,
                        heading: 0.04640137739184258,
                        pitch: -0.5795598363240879,
                        roll: 1.0391687510491465e-13
                    }
                },
                {
                    line: '塘桥站',
                    location: {
                        lng: 4362.110,
                        lat: -2986.490,
                        height: 368.676,
                        heading: 0.04640137739184169,
                        pitch: -0.5795598363240875,
                        roll: 1.056932319443149e-13
                    }
                },
                {
                    line: '潍坊路站',
                    location: {
                        lng: 4403.872,
                        lat: -1840.547,
                        height: 394.765,
                        heading: 0.04640137739184702,
                        pitch: -0.5795598363240941,
                        roll: 1.0480505352461478e-13
                    }
                },
                {
                    line: '商城路站',
                    location: {
                        lng: 4099.358,
                        lat: -829.877,
                        height: 372.842,
                        heading: 0.04640137739184702,
                        pitch: -0.5795598363240781,
                        roll: 1.0480505352461478e-13
                    }
                },
                {
                    line: '浦东南路站',
                    location: {
                        lng: 3864.472,
                        lat: -233.069,
                        height: 323.757,
                        heading: 0.0464013773918337,
                        pitch: -0.579559836324028,
                        roll: 1.199040866595169e-13
                    }
                },
                {
                    line: '提篮桥站',
                    location: {
                        lng: 3174.986,
                        lat: 1837.713,
                        height: 305.718,
                        heading: 0.046401377391831033,
                        pitch: -0.5795598363240333,
                        roll: 1.270095140171179e-13
                    }
                },
                {
                    line: '周家嘴路站',
                    location: {
                        lng: 2768.648,
                        lat: 2337.886,
                        height: 305.718,
                        heading: 0.04640137739183636,
                        pitch: -0.5795598363240342,
                        roll: 1.2434497875801753e-13
                    }
                },
                {
                    line: '海伦路站',
                    location: {
                        lng: 1812.266,
                        lat: 2482.180,
                        height: 305.718,
                        heading: 0.04640137739184258,
                        pitch: -0.5795598363240386,
                        roll: 1.127986593019159e-13
                    }
                },
                {
                    line: '甜爱路站',
                    location: {
                        lng: 1143.224,
                        lat: 2919.123,
                        height: 305.718,
                        heading: 0.046401377391831033,
                        pitch: -0.5795598363240448,
                        roll: 1.1546319456101628e-13
                    }
                },
                {
                    line: '上海外国语大学站',
                    location: {
                        lng: 1064.675,
                        lat: 4041.572,
                        height: 305.718,
                        heading: 0.04640137739168626,
                        pitch: -0.5795598363240471,
                        roll: 2.282618538629322e-13
                    }
                },
                {
                    line: '凉城路站',
                    location: {
                        lng: -111.283,
                        lat: 4606.201,
                        height: 305.718,
                        heading: 0.046401377391688925,
                        pitch: -0.5795598363240471,
                        roll: 2.291500322826323e-13
                    }
                },
                {
                    line: '广灵四路站',
                    location: {
                        lng: -545.693,
                        lat: 5479.628,
                        height: 305.718,
                        heading: 0.046401377391683596,
                        pitch: -0.5795598363240417,
                        roll: 2.3092638912203256e-13
                    }
                },
                {
                    line: '车站北路站',
                    location: {
                        lng: -415.920,
                        lat: 6444.601,
                        height: 305.718,
                        heading: 0.04640137739167294,
                        pitch: -0.5795598363240404,
                        roll: 2.318145675417327e-13
                    }
                },
                {
                    line: '虹湾路站',
                    location: {
                        lng: -338.162,
                        lat: 8221.843,
                        height: 305.718,
                        heading: 0.04640137739167294,
                        pitch: -0.5795598363240386,
                        roll: 2.3092638912203256e-13
                    }
                },
                {
                    line: '一二八纪念路站',
                    location: {
                        lng: -398.679,
                        lat: 10228.410,
                        height: 305.718,
                        heading: 0.04640137739167738,
                        pitch: -0.5795598363240413,
                        roll: 2.327027459614328e-13
                    }
                },
                {
                    line: '呼玛路站',
                    location: {
                        lng: -767.814,
                        lat: 11712.309,
                        height: 305.718,
                        heading: 0.046401377391674714,
                        pitch: -0.5795598363240391,
                        roll: 2.3359092438113294e-13
                    }
                },
                {
                    line: '江杨南路站',
                    location: {
                        lng: -527.813,
                        lat: 12442.271,
                        height: 305.718,
                        heading: 0.04640137739167294,
                        pitch: -0.5795598363240408,
                        roll: 2.327027459614328e-13
                    }
                },
                {
                    line: '泰和路站',
                    location: {
                        lng: -380.245,
                        lat: 13835.754,
                        height: 305.718,
                        heading: 0.0464013773916756,
                        pitch: -0.5795598363240355,
                        roll: 2.3003821070233244e-13
                    }
                },
                {
                    line: '兰岗路站',
                    location: {
                        lng: -971.114,
                        lat: 15359.383,
                        height: 305.718,
                        heading: 0.046401377391673826,
                        pitch: -0.5795598363240253,
                        roll: 2.3003821070233244e-13
                    }
                },
                {
                    line: '铁山路站',
                    location: {
                        lng: -1465.804,
                        lat: 16350.035,
                        height: 305.718,
                        heading: 0.04640137739167294,
                        pitch: -0.5795598363240249,
                        roll: 2.318145675417327e-13
                    }
                },
                {
                    line: '铁通路站',
                    location: {
                        lng: -1845.008,
                        lat: 17157.820,
                        height: 305.718,
                        heading: 0.04640137739167294,
                        pitch: -0.5795598363240284,
                        roll: 2.318145675417327e-13
                    }
                },
                {
                    line: '宝山站',
                    location: {
                        lng: -2388.031,
                        lat: 18267.018,
                        height: 305.718,
                        heading: 0.04640137739167294,
                        pitch: -0.5795598363240346,
                        roll: 2.318145675417327e-13
                    }
                }
            ]
        },
        {
            name: '21号线', value: 35, key: "21号线",
            ygLine: "yg_line21e",
            lineLocation: {
                lng: 15023.944,
                lat: -57623.063,
                height: 44620.419,
                heading: 0.033869712611886094,
                pitch: -0.6659651373168334,
                roll: 6.283185307179476
            },
            lineList: [
                {
                    line: '东靖路站',
                    location: {
                        lng: 11378.419,
                        lat: 5830.048,
                        height: 515.255,
                        heading: 0.03386971261189409,
                        pitch: -0.6659651373168538,
                        roll: 6.28318530717946
                    }
                },
                {
                    line: '杨高北路站',
                    location: {
                        lng: 12605.082,
                        lat: 2030.929,
                        height: 2727.862,
                        heading: 0.03386971261190652,
                        pitch: -0.6659651373168294,
                        roll: 6.283185307179441
                    }
                },
                {
                    line: '凌河路站',
                    location: {
                        lng: 12650.177,
                        lat: 2842.546,
                        height: 1164.631,
                        heading: 0.033869712611886094,
                        pitch: -0.6659651373168178,
                        roll: 6.283185307179471
                    }
                },
                {
                    line: '金桥站',
                    location: {
                        lng: 13058.654,
                        lat: 2312.861,
                        height: 349.114,
                        heading: 0.03386971261188165,
                        pitch: -0.6659651373168254,
                        roll: 6.28318530717948
                    }
                },
                {
                    line: '云桥路站',
                    location: {
                        lng: 13602.066,
                        lat: 1430.256,
                        height: 393.736,
                        heading: 0.033869712611880765,
                        pitch: -0.6659651373168236,
                        roll: 6.283185307179481
                    }
                },
                {
                    line: '浦东足球场站',
                    location: {
                        lng: 13856.413,
                        lat: 306.555,
                        height: 378.793,
                        heading: 0.033869712611886094,
                        pitch: -0.6659651373168769,
                        roll: 6.283185307179476
                    }
                },
                {
                    line: '龙东大道站',
                    location: {
                        lng: 13853.283,
                        lat: -1990.648,
                        height: 350.021,
                        heading: 0.03386971261189231,
                        pitch: -0.6659651373169657,
                        roll: 6.283185307179474
                    }
                },
                {
                    line: '广兰路站',
                    location: {
                        lng: 14015.807,
                        lat: -2952.085,
                        height: 269.949,
                        heading: 0.033869712611894975,
                        pitch: -0.6659651373170337,
                        roll: 6.283185307179474
                    }
                },
                {
                    line: '高斯路站',
                    location: {
                        lng: 13619.528,
                        lat: -3978.974,
                        height: 324.412,
                        heading: 0.03386971261188698,
                        pitch: -0.6659651373169444,
                        roll: 6.283185307179474
                    }
                },
                {
                    line: '张衡路站',
                    location: {
                        lng: 13430.626,
                        lat: -4981.887,
                        height: 310.796,
                        heading: 0.033869712611880765,
                        pitch: -0.6659651373168667,
                        roll: 6.2831853071794725
                    }
                },
                {
                    line: '学林路站',
                    location: {
                        lng: 13499.148,
                        lat: -5816.989,
                        height: 294.501,
                        heading: 0.0338697126118781,
                        pitch: -0.6659651373168596,
                        roll: 6.283185307179476
                    }
                },
                {
                    line: '军民路站',
                    location: {
                        lng: 13704.491,
                        lat: -6757.594,
                        height: 180.854,
                        heading: 0.03386971261187721,
                        pitch: -0.6659651373168649,
                        roll: 6.28318530717948
                    }
                },
                {
                    line: '康南路站',
                    location: {
                        lng: 13986.729,
                        lat: -7782.359,
                        height: 233.033,
                        heading: 0.06962781176883936,
                        pitch: -0.6649421293218261,
                        roll: 6.28318530717948
                    }
                },
                {
                    line: '张江站',
                    location: {
                        lng: 13875.018,
                        lat: -9973.339,
                        height: 298.076,
                        heading: 0.01875210426426044,
                        pitch: -0.6623663341352106,
                        roll: 6.28318530717948
                    }
                },
                {
                    line: '申江南路站',
                    location: {
                        lng: 14729.709,
                        lat: -10958.738,
                        height: 381.03,
                        heading: 0.018752104264261327,
                        pitch: -0.6623663341352106,
                        roll: 6.283185307179476
                    }
                },
                {
                    line: '迪士尼站',
                    location: {
                        lng: 18454.054,
                        lat: -10684.988,
                        height: 305.824,
                        heading: 0.018752104264263103,
                        pitch: -0.662366334135216,
                        roll: 6.283185307179476
                    }
                },
                {
                    line: '唐黄路站',
                    location: {
                        lng: 20362.443,
                        lat: -10351.414,
                        height: 359.852,
                        heading: 0.018752104264261327,
                        pitch: -0.6623663341352253,
                        roll: 6.28318530717948
                    }
                },
                {
                    line: '六陈路站',
                    location: {
                        lng: 22763.696,
                        lat: -9480.458,
                        height: 263.255,
                        heading: 0.01875210426426044,
                        pitch: -0.6623663341352115,
                        roll: 6.28318530717948
                    }
                }
            ]
        },
        {
            name: '23号线', value: 35, key: "23号线",
            ygLine: 'yg_line23',
            lineLocation: {
                lng: -5147.915,
                lat: -81794.987,
                height: 52423.589,
                heading: 0.03386971261176264,
                pitch: -0.6624057821120344,
                roll: 6.283185307179561
            },
            lineList: [
                {
                    line: '上海体育场站',
                    location: {
                        lng: -2652.881,
                        lat: -6360.968,
                        height: 565.133,
                        heading: 6.207395672247364,
                        pitch: -0.601460807606359,
                        roll: 6.28318530717957
                    }
                },
                {
                    line: '龙漕路站',
                    location: {
                        lng: -2396.105,
                        lat: -7760.377,
                        height: 565.133,
                        heading: 6.040587725776135,
                        pitch: -0.7028156139112909,
                        roll: 6.28318530717957
                    }
                },
                {
                    line: '龙启路站',
                    location: {
                        lng: -2028.808,
                        lat: -8854.863,
                        height: 648.704,
                        heading: 6.0393951548709675,
                        pitch: -0.7069339417349498,
                        roll: 6.28318530717957
                    }
                },
                {
                    line: '上海植物园站',
                    location: {
                        lng: -1966.055,
                        lat: -9488.007,
                        height: 396.398,
                        heading: 5.938249164216664,
                        pitch: -0.93574615162375,
                        roll: 6.28318530717956
                    }
                },
                {
                    line: '龙瑞路站',
                    location: {
                        lng: -1737.597,
                        lat: -10995.498,
                        height: 396.398,
                        heading: 5.925243017052928,
                        pitch: -0.9633044811382274,
                        roll: 6.28318530717954
                    }
                },
                {
                    line: '徐浦大桥站',
                    location: {
                        lng: -1363.140,
                        lat: -12001.395,
                        height: 396.398,
                        heading: 5.934174837634418,
                        pitch: -1.0568243985255017,
                        roll: 6.283185307179512
                    }
                },
                {
                    line: '华泾路站',
                    location: {
                        lng: -1442.302,
                        lat: -12716.213,
                        height: 391.267,
                        heading: 5.569871791901576,
                        pitch: -1.551278961980088,
                        roll: 0
                    }
                },
                {
                    line: '景联路站',
                    location: {
                        lng: -1727.267,
                        lat: -14893.737,
                        height: 343.535,
                        heading: 0.03386971261175997,
                        pitch: -0.6624057821120246,
                        roll: 6.283185307179558
                    }
                },
                {
                    line: '龙吴路站',
                    location: {
                        lng: -1360.273,
                        lat: -16300.951,
                        height: 338.384,
                        heading: 0.03451401757414008,
                        pitch: -0.6637851160621473,
                        roll: 6.283185307179551
                    }
                },
                {
                    line: '澄江路站',
                    location: {
                        lng: -1177.746,
                        lat: -17130.075,
                        height: 338.384,
                        heading: 0.03410493635393763,
                        pitch: -0.6652223354488793,
                        roll: 6.283185307179551
                    }
                },
                {
                    line: '墨江路站',
                    location: {
                        lng: -1182.565,
                        lat: -18609.338,
                        height: 497.341,
                        heading: 0.04457320395223974,
                        pitch: -0.7136471289524446,
                        roll: 6.283185307179565
                    }
                },
                {
                    line: '吴泾北站',
                    location: {
                        lng: -906.992,
                        lat: -19538.285,
                        height: 494.64,
                        heading: 0.028514095563914488,
                        pitch: -0.7509243352681678,
                        roll: 6.283185307179565
                    }
                },
                {
                    line: '放鹤路站',
                    location: {
                        lng: -497.746,
                        lat: -21093.353,
                        height: 494.64,
                        heading: 0.043974155116834446,
                        pitch: -0.8048461925877088,
                        roll: 6.283185307179567
                    }
                },
                {
                    line: '紫龙路站',
                    location: {
                        lng: -267.546,
                        lat: -22446.938,
                        height: 494.64,
                        heading: 0.10600983526914742,
                        pitch: -0.9628875387511071,
                        roll: 6.2831853071795685
                    }
                },
                {
                    line: '江川东路站',
                    location: {
                        lng: -743.613,
                        lat: -23074.683,
                        height: 371.451,
                        heading: 6.18706998752768,
                        pitch: -1.0558827209170412,
                        roll: 6.2831853071795685
                    }
                },
                {
                    line: '紫竹高新区站',
                    location: {
                        lng: -1848.762,
                        lat: -23432.984,
                        height: 379.062,
                        heading: 6.187069987527683,
                        pitch: -1.055882720917043,
                        roll: 6.2831853071795685
                    }
                },
                {
                    line: '沪金高速站',
                    location: {
                        lng: -3335.081,
                        lat: -23957.943,
                        height: 370.35,
                        heading: 6.187069987527696,
                        pitch: -1.0558827209170407,
                        roll: 6.283185307179567
                    }
                },
                {
                    line: '东川路站',
                    location: {
                        lng: -4611.395,
                        lat: -24611.018,
                        height: 637.884,
                        heading: 6.187069987527702,
                        pitch: -1.0558827209170385,
                        roll: 6.283185307179565
                    }
                },
                {
                    line: '金平路站',
                    location: {
                        lng: -5327.277,
                        lat: -24689.566,
                        height: 403.636,
                        heading: 6.187069987527703,
                        pitch: -1.0558827209170358,
                        roll: 6.283185307179565
                    }
                },
                {
                    line: '华宁路站',
                    location: {
                        lng: -7477.029,
                        lat: -25264.480,
                        height: 303.56,
                        heading: 6.187069987527697,
                        pitch: -1.0558827209170372,
                        roll: 6.283185307179565
                    }
                },
                {
                    line: '文井路站',
                    location: {
                        lng: -8487.830,
                        lat: -25623.442,
                        height: 408.806,
                        heading: 6.187069987527697,
                        pitch: -1.0558827209170376,
                        roll: 6.283185307179563
                    }
                },
                {
                    line: '闵行开发区站',
                    location: {
                        lng: -10345.075,
                        lat: -26222.104,
                        height: 386.776,
                        heading: 6.1870699875277015,
                        pitch: -1.0558827209170207,
                        roll: 6.283185307179558
                    }
                },
            ]
        },
        {
            name: '崇明线', value: 35, key: "崇明线",
            ygLine: "",
            lineLocation: { // 崇明线
                lng: 17738.680,
                lat: -38520.332,
                height: 39000.184,
                heading: 0.03386971261176974,
                pitch: -0.6624057821120326,
                roll: 6.28318530717956
            },
            lineList: [
                {
                    line: '金吉路站',
                    location: {
                        lng: 14667.133,
                        lat: 2636.624,
                        height: 815.309,
                        heading: 0.03386971261176264,
                        pitch: -0.6624057821120259,
                        roll: 6.283185307179565
                    },
                },
                {
                    line: '申江路站',
                    location: {
                        lng: 14634.786,
                        lat: 4672.239,
                        height: 528.489,
                        heading: 0.03386971261176086,
                        pitch: -0.6624057821120259,
                        roll: 6.28318530717957
                    }
                },
                {
                    line: '高宝路站',
                    location: {
                        lng: 14728.157,
                        lat: 5917.741,
                        height: 413.4,
                        heading: 0.03386971261176086,
                        pitch: -0.662405782112025,
                        roll: 6.283185307179572
                    }
                },
                {
                    line: '凌空北路站',
                    location: {
                        lng: 19285.023,
                        lat: 6192.229,
                        height: 439.499,
                        heading: 0.03386971261175997,
                        pitch: -0.6624057821120166,
                        roll: 6.283185307179572
                    }
                },
                {
                    line: '浦东大小盾构转换段',
                    location: {
                        lng: 20383.787,
                        lat: 7913.254,
                        height: 298.659,
                        heading: 0.03386971261176264,
                        pitch: -0.6624057821120064,
                        roll: 6.2831853071795685
                    }
                },
                {
                    line: '1#大小盾构转换段',
                    location: {
                        lng: 23194.319,
                        lat: 15204.968,
                        height: 324.227,
                        heading: 0.033869712611758196,
                        pitch: -0.6624057821119864,
                        roll: 6.283185307179572
                    }
                },
                {
                    line: '长兴岛站',
                    location: {
                        lng: 23867.358,
                        lat: 17291.925,
                        height: 230.018,
                        heading: 0.03386971261175553,
                        pitch: -0.66240578211199,
                        roll: 6.283185307179572
                    }
                },
                {
                    line: '长兴岛主变电所',
                    location: {
                        lng: 23998.129,
                        lat: 17587.735,
                        height: 229.783,
                        heading: 0.03386971261175553,
                        pitch: -0.6624057821119878,
                        roll: 6.283185307179572
                    }
                }
            ]

        },
    ]
}


//-------------在建车站弹窗-----------------

/**
 * 车站信息
 */
export const stationDefault = {
    site: "",
    state: "",
    stationType: ""
}

export const stationDataLiatDefault = [
    {
        key: "",
        value: 0
    }
]


/**
 * 参建单位
 */
export const participatingUnitsDefault = {
    site: "",
    state: ""
}

export const participatingUnitsListDefault = [
    {
        key:"",
        value: 0
    }
]


/**
 * 前期证照
 */
export const earlyCertificationDefault = {
    site: "",
    state: "",
    data: [
        {
            licenseName: "",
            completionStatus: "",
            plannedCompletionTime: "",
            actualCompletionTime: "",
            delayDays: 0,
            daysRemaining: 0,
            fileAddress: ""
        }
    ]
}


/**
 * 动迁腾地
 */
export const relocationTengdiDefaule = {
    site: "",
    state: "",
    data: [
        {
            completionRateName: "居民动迁完成率",
            completionRate: "0",
            totalName: "动迁总数",
            total: 0,
            completedNumName: "动迁完成",
            completedNum: 0
        },
        {
            completionRateName: "单位动迁完成率",
            completionRate: "0",
            totalName: "动迁总数",
            total: 0,
            completedNumName: "动迁完成",
            completedNum: 0
        },
        {
            completionRateName: "绿地动迁完成率",
            completionRate: "0",
            totalName: "总面积",
            total: 0,
            completedNumName: "完成面积",
            completedNum: 0
        }
    ]
}


/**
 * 管线搬迁
 */
export const pipelineRelocation = {
    site: "",
    state: "",
    data: [
        {
            title: "",
            completed: 0,
            inProgress: 0,
            delaying: 0,
            notStarted: 0,
            id: ""
        }
    ]
}


/**
 * 管线搬迁详情
 */

export const pipelineRelocationDetails = [
    {
        name: "",
        dataList: [
            {
                relocateName: "",
                relocateState: ""
            }
        ]
    }
]


/**
 * 质量安全指标面板对接接口版本
 */
export const significantRiskDefault = {
    "基坑": { level1MajorRisks: 0, riskTotal: 0, secure: 0, control: 0, focus: 0},
    "旁通道": { level1MajorRisks: 0, riskTotal: 0, secure: 0, control: 0, focus: 0},
    "区间": { level1MajorRisks: 0, riskTotal: 0, secure: 0, control: 0, focus: 0},
  }


export const currentRiskDefault = {
    outShapeValue: 1.8,
    bottomLoseRate: 4.8,
    dbcjVariable: 0,
  }


export const currentRiskDetailDefault = {
    pit: 0,
    interval: 0,
    superMajorBridge: 0,
    pitCount: 0,
    intervalCount: 0,
    superMajorBridgeCount: 0,
  }
