import { logError } from "../util/log";
import { Socket } from "../net/socket_server";
import { getDpData } from "../data/interface/wsData";



let connectionPool = {};


let data = [
    {
        type:'warn', 
        position:{
            x: 6378135.248040633,
            y: -1491.9380484303829,
            z: 1850.1137940254034
        },
        vfx: {
            width: '100px',
            height: '200px',
            img: 'http://192.168.0.71:40001/kineticEffect/色相饱和度994.png' //图片地址
        }
    }
]

export function broadcastMsg(data) {
    for (let key in connectionPool) {
        let result = {code:200, success:true, data};
        try {
            connectionPool[key].send(JSON.stringify(result));
        } catch(err) {
            logError(`广播消息失败: ${err}`);
        }
    }
}


function analysisUserUrl(req) {
    let ip = req.headers['x-forwarded-for'] || req.connection.remoteAddress || req.socket.remoteAddress || req.connection.socket.remoteAddress;
    return ip;
}



export async function initSocketServer(port) {
    Socket.createServer(port, function (wss) {
        wss.on('connection', function(ws, req) {
            let ip = analysisUserUrl(req);
            connectionPool[ip] = ws;

            ws.on('message', function(data)  {
                //回应心跳包
                if (data == 'i am heart') ws.send(JSON.stringify({success:true, code:199}));
            });
    
            ws.on('close', function (data){
                if ( ws._socket &&  ws._socket._peername && ws._socket._peername.address ) {
                    let userId = ws._socket._peername.address;
                    console.log("close", userId);
                    delete connectionPool[userId];
                }
                
            });

            let {initList, count} = getDpData();
            // console.log(`前端连接本服务成功  =>  userId:${ip}, 发送初始化车辆：${count} 辆`);
            initList.forEach(info => {
                ws.send(JSON.stringify({code:200, success:true, data:info}));
            });

        });
    });
}

