/**
 * 建设指挥 
 * 在建站点弹窗
 * 车站信息 
 * 4.0
 * 处理数据
 */

import { stationDataLiatDefault, stationDefault } from "../../config/defaultConfig";
import { stationTableData } from "../../data/table/stationPopupData";
import { change, getPopupOneData } from "../../dataPackage/inBackOut";
import { separateDataAndUint } from "../../dataPackage/tool";


/**
 * 车站信息
 * @param line 线路名称
 * @param site 站点名称
 * @returns stationInfo: { site:"站点名称", state:"站点状态", stationType:"车站类型"}
 * @returns dataList: [ { key:"数据名称", value:数据值, unit:"单位" }, ...... ]
 * key："建筑面积", "站台长度", "站台宽度", "建设周期", "车站出入口", "车站风井"
 */
export async function getStation(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = stationTableData();
    
    //"线路", "站点名称", "站点状态", "车站类型", "建筑面积", "站台长度", "站台宽度", "建设周期", "车站出入口", "车站风井"
    let data = change(["line", "site", "state", "stationType", "建筑面积", "站台长度", "站台宽度", "建设周期", "车站出入口", "车站风井"], tableData["车站信息数据"].bodyList );

    let conf = ["site", "state", "stationType"];
    let station = getPopupOneData(line, data, conf);

    let dataListConf = ["建筑面积", "站台长度", "站台宽度", "建设周期", "车站出入口", "车站风井"];
    let dataList =  getPopupOneData(line, data, dataListConf);

    let stationDataList = [];
    for(let key in dataList[site]) {
        let {dataNum, dataUnit} = separateDataAndUint(dataList[site][key]);
        stationDataList.push({key, value: dataNum, unit: dataUnit});
    }

    let result = {};

    result["stationInfo"] = station[site] || stationDefault;
    result["dataList"] = stationDataList || stationDataLiatDefault;

    res.send(result);

    return result;
}
