/**
 * 建设指挥 
 * 在建站点弹窗
 * 智慧工地 
 * 4.0
 * 处理数据
 */

import { smartConstructionSiteTableData, surveillanceVideoTableData,  gateDataTableData, monitoringDataTableData} from "../../data/table/stationPopupData";
import { change } from "../../dataPackage/inBackOut";

/**
 * 智慧工地基础数据
 * @param line 线路名称
 * @param site 站点名称
 * @returns smartConstructionSite: {
 * videoList:[{name:"监控视频名称", url:"监控视频地址"}, ...... ], 
 * gateList:{ mobilizationPeopleNum:"进场人数", exitPeopleNum:"退场人数", presencePeopleNum:"在场人数", notCheckedIn:"未签到", notSignedOut:"未签退", gateId:"闸机编号" }, 
 * monitoringList:[{ monitoringType:"监测类型", measurementPoints:"测点数", monitoringId:"监测数据编号" }, ...... ]}
 */
export async function getSmartConstructionSite(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = smartConstructionSiteTableData();
    
    //"线路", "站点名称", "站点状态", "监控视频编号", "进场人数", "退场人数", "在场人数", "未签到", "未签退", "闸机编号", "监测类型", "测点数", "监测数据编号"
    let data = change(["line", "site", "state", "videoId", "mobilizationPeopleNum", "exitPeopleNum", "presencePeopleNum", "notCheckedIn", "notSignedOut", "gateId", "monitoringId"], tableData["智慧工地数据"].bodyList );

    let conf = ["line", "site", "state", "videoId", "mobilizationPeopleNum", "exitPeopleNum", "presencePeopleNum", "notCheckedIn", "notSignedOut", "gateId", "monitoringId"];

    let smartConstructionSite:any = {};

    data.forEach(item => {
        let dataLine = item.line;
        let dataSite = item.site;

        if (line == dataLine) {
            if (!smartConstructionSite[dataSite]) smartConstructionSite[dataSite] = {videoList:[], gateList:{}, monitoringList:[]};

            //**监控视频 */
            let videoTableData = surveillanceVideoTableData();
            let surveillanceVideoData = [];
            let videoId = item.videoId;
            for (let videoKey in videoTableData) {
                if (videoId == videoKey) {
                    //"监控视频区域名称", "监控视频地址"
                    surveillanceVideoData = change(["name", "url"], videoTableData[videoKey].bodyList);
                    smartConstructionSite[dataSite]["videoList"] = surveillanceVideoData;
                }
            }

            /**闸机数据 */
            //"进场人数", "退场人数", "在场人数", "未签到", "未签退", "闸机编号"
            let gateConf = ["mobilizationPeopleNum", "exitPeopleNum", "presencePeopleNum", "notCheckedIn", "notSignedOut", "gateId"];
            for (let gateName = 0; gateName < gateConf.length; gateName++) {
                smartConstructionSite[dataSite]["gateList"][gateConf[gateName]] = item[gateConf[gateName]];
            }

            /**
             * 监测数据
             */
            let monitoringId = item.monitoringId;
            //"监测类型", "测点数", "监测数据编号"
            let monitoringData = change(["monitoringType", "measurementPoints", "monitoringId"], tableData["监测数据"].bodyList);
            monitoringData.forEach( monitoringItem => {
                let id = monitoringItem.monitoringId;
                if (id.search(monitoringId) > -1) {
                    smartConstructionSite[dataSite]["monitoringList"].push(monitoringItem);
                }
            })
        }
    });

    let result = {"smartConstructionSite": smartConstructionSite[site]};

    res.send(result);

    return result;
}


/**
 * 智慧工地闸机数据
 * @param gateId 闸机编号
 * @returns gateDetails: {
 * jobStatistics:[{ personnelType:"人员类型", mobilizationPeopleNum:"进场人数", exitPeopleNum:"退场人数", presencePeopleNum:"在场人数" }, ...... ], 
 * teamStatistics:[{ unitName:"单位名称", mobilizationPeopleNum:"进场人数", exitPeopleNum:"退场人数", presencePeopleNum:"在场人数" }, ...... ]
 * @returns 
 */
export async function getGateData(req, res) {
    let gateId = req.query.gateId || "17号线西岑站1";
    let tableData = gateDataTableData();

    let result:any = {};
    let details = {jobStatistics:[], teamStatistics:[]};
    for (let key in tableData) {
        if (key.search(gateId) > -1) {
            let regex = /\（(.+?)\）/g;
            let name = key.match(regex)[0].replace("（", "").replace("）", "");
            
            if (name == "工种") {
                details["jobStatistics"] = change(["personnelType", "mobilizationPeopleNum", "exitPeopleNum", "presencePeopleNum"], tableData[`${gateId}（${name}）`].bodyList);
            } else if (name == "班组") {
                details["teamStatistics"] = change(["unitName", "mobilizationPeopleNum", "exitPeopleNum", "presencePeopleNum"], tableData[`${gateId}（${name}）`].bodyList);
            }
        }
    }

    result["gateDetails"] = details;

    res.send(result);

    return result;
}


/**
 * 智慧工地监测数据详情
 * @param monitoringId 监测数据编号
 * @returns monitoring: {
 * "测点名称":{
 *  "累计变化量":{"日期":[{ name:"第三方监测位移(mm)累计变化量", value:0 }, { name:"施工监测位移(mm)累计变化量", value:0 }], ...... },
 *  "日变化量":{"日期":[{ name:"第三方监测位移(mm)日变化量", value:0 }, { name:"施工监测位移(mm)日变化量", value:0 }], ...... }
 *  }, ...... 
 * }
 * @returns 
 */
export async function getMonitoringData(req, res) {
    let monitoringId = req.query.monitoringId|| "17号线西岑站1（沉降）";
    let tableData = monitoringDataTableData();
    
    //"测点名称", "日期", "第三方监测位移累计变化量", "第三方监测位移日变化量", "施工监测位移累计变化量", "施工监测位移日变化量"
    let monitoringTable = change(["measurementPointName", "time", "thirdPartyAccumulatedChange", "thirdPartyDailyVariation", "constructionAccumulatedChange", "constructionDailyVariation"], tableData[monitoringId].bodyList);
    let conf = ["time", "thirdPartyAccumulatedChange", "thirdPartyDailyVariation", "constructionAccumulatedChange", "constructionDailyVariation"];

    let monitoring = {};
    monitoringTable.forEach(item => {
        let measurementPointName = item.measurementPointName;

        let monitoringData = {};
        if (!monitoring[measurementPointName]) monitoring[measurementPointName] = [];
            
        for (let name = 0; name < conf.length; name++) {
            monitoringData[conf[name]] = item[conf[name]];
        }
        monitoring[measurementPointName].push(monitoringData);
    });

    let monitoringDetails = {};
    for (let key in monitoring) {
        if (!monitoringDetails[key]) monitoringDetails[key] = {"累计变化量":{}, "日变化量":{}};
        
        monitoring[key].forEach( item => {
            let {time, thirdPartyAccumulatedChange, thirdPartyDailyVariation, constructionAccumulatedChange, constructionDailyVariation} = item;
            //累计变化量
            let accumulatedChange = [{name:"第三方监测位移(mm)累计变化量", value:thirdPartyAccumulatedChange}, {name: "施工监测位移(mm)累计变化量", value:constructionAccumulatedChange}];
            //日变化量 
            let dailyVariation = [{name:"第三方监测位移(mm)日变化量", value:thirdPartyDailyVariation}, {name: "施工监测位移(mm)日变化量", value:constructionDailyVariation}];
        
            monitoringDetails[key]["累计变化量"][time] = accumulatedChange;
            monitoringDetails[key]["日变化量"][time] = dailyVariation;
        })
    }

    let result:any = {"monitoring": monitoringDetails};

    res.send(result);

    return result;
}
