/**
 * 建设指挥 
 * 在建站点弹窗
 * 风险隐患 
 * 4.0
 * 处理数据
 */

import { riskHazardsDetailsTableData, riskHazardsTableData } from "../../data/table/stationPopupData";
import { change, getPopupMoreData } from "../../dataPackage/inBackOut";


/**
 * 风险隐患
 * @param line 线路名称
 * @param site 站点名称
 * @returns riskHazards: { site:"站点名称", state:"站点状态", total:风险隐患数, data:[{数据列表}, ...... ]}
 * data:[{ riskName:"风险名称", riskLevel:"风险等级", riskId:"风险编号" }, ...... ]
 */
export async function getRiskHazards(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = riskHazardsTableData();
    
    //"线路", "站点名称", "站点状态", "风险隐患数", "风险名称", "风险等级", "风险编号"
    let data = change(["line", "site", "state", "riskName", "riskLevel", "riskId"], tableData["风险隐患数据"].bodyList );

    let conf = ["riskName", "riskLevel", "riskId"];

    let riskHazards = getPopupMoreData(line, data, conf);
    
    riskHazards[site]["total"] = riskHazards[site]["data"].length || 0;

    let result = {"riskHazards": riskHazards[site]};

    res.send(result);

    return result;
}


/**
 * 风险隐患详情
 * @param riskId 风险编号
 * @returns details:[ { name:"隐患详情名称", value:"隐患详情内容" }, { name:"", value:"" }, ...... ]
 */
export async function getRiskHazardsDetails(req, res) {
    let riskId = req.query.riskId|| "17号线西岑站1";
    let tableData = riskHazardsDetailsTableData();

    let result:any = {};

    let data = change(["name", "value"], tableData[riskId].bodyList);
    
    result["details"] = data;

    res.send(result);

    return result;
}
