/**
 * 建设指挥 
 * 在建站点弹窗
 * 遗留问题 
 * 4.0
 * 处理数据
 */

import { remainingProblemsTableData } from "../../data/table/stationPopupData";
import { change, getPopupMoreData } from "../../dataPackage/inBackOut";


/**
 * 遗留问题
 * @param line 线路名称 
 * @param site 站点名称
 * @returns remainingProblems: {site: "站点名称", state: "站点状态", data: [{数据列表}]}
 * data:[{ problemName:"问题名称", problemDescription:"问题说明", fillingTime:"填报时间", reportingDepartment:"填报部门" }] 
 */
export async function getRemainingProblems(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = remainingProblemsTableData();
    
    //"线路", "站点名称", "站点状态", "问题名称", "问题说明", "填报时间", "填报部门"
    let data = change(["line", "site", "state", "problemName", "problemDescription", "fillingTime", "reportingDepartment"], tableData["遗留问题数据"].bodyList );

    let conf = ["problemName", "problemDescription", "fillingTime", "reportingDepartment"];
    
    let remainingProblems = getPopupMoreData(line, data, conf);

    let result = {"remainingProblems": remainingProblems[site]}
    result["remainingProblems"]["total"] = result["remainingProblems"]["data"].length || 0;
    res.send(result);

    return result;
}