/**
 * 建设指挥 
 * 在建站点弹窗
 * 动迁腾地 
 * 3.0
 * 处理数据
 */

import { relocationTengdiDefaule } from "../../config/defaultConfig";
import { relocationTengdiTableData } from "../../data/table/stationPopupData";
import { change, getPopupMoreData } from "../../dataPackage/inBackOut";


/**
 * 动迁腾地
 * @param line 线路名称
 * @param site 站点名称
 * @returns relocationTengdi: { site:"站点名称", state:"站点状态", data:[{数据列表}, ...... ]}
 * data:[{
 *      completionRateName:"完成率名称",
 *      completionRate:完成率,
 *      totalName:"总数名称",
 *      total:总数,
 *      completedNumName:"完成数名称",
 *      completedNum:完成数
 * }, ...... ]
 */
export async function getRelocationTengdi(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = relocationTengdiTableData();
    
    //"线路", "站点名称", "站点状态", "完成率名称", "完成率", "总数名称", "总数", "完成数名称", "完成数"
    let data = change(["line", "site", "state", "completionRateName", "completionRate", "totalName", "total", "completedNumName", "completedNum"], tableData["动迁腾地数据"].bodyList );

    let conf = ["completionRateName", "completionRate", "totalName", "total", "completedNumName", "completedNum"];
    
    let relocationTengdi = getPopupMoreData(line, data, conf);

    let result = {"relocationTengdi": relocationTengdi[site] || relocationTengdiDefaule};

    res.send(result);

    return result;
}


