/**
 * 建设指挥 
 * 在建站点弹窗
 * 管线搬迁 
 * 4.0
 * 处理数据
 */

import { pipelineRelocationDetailsTableData, pipelineRelocationTableData } from "../../data/table/stationPopupData";
import { change, getPopupDetailsData } from "../../dataPackage/inBackOut";


/**
 * 管线搬迁基础数据
 * @param line 线路名称
 * @param site 站点名称
 * @returns pipelineRelocation: { site:"站点名称", state:"站点状态", data:[{数据列表}, ...... ]}
 * data:[{
 *  title:"标题", 【道路翻胶、电力、电信、非电信、雨水、污水、上水、燃气】
 *  list:[{
 *      completed:已完成数量,
 *      inProgress:进行中数量,
 *      delaying:延误中数量,
 *      notStarted:未开始数量,
 *      stage:"阶段", --该字段只有标题为道路翻胶时有
 *      id:"管线搬迁编号"
 *  }, ...... ]
 * }, ...... ]
 */
export async function getPipelineRelocation(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = pipelineRelocationTableData();
    
    //"线路", "站点名称", "站点状态", "标题", "已完成", "进行中", "延误中", "未开始", "", "管线搬迁编号"
    let data = change(["line", "site", "state", "title", "completed", "inProgress", "delaying", "notStarted", "stage", "id"], tableData["管线搬迁数据"].bodyList );

    let conf = ["completed", "inProgress", "delaying", "notStarted", "id"];
    let stageConf = ["completed", "inProgress", "delaying", "notStarted", "stage", "id"];

    let pipelineRelocation:any = {};

    let stageList = [];
    data.forEach(item => {
        let dataLine = item.line;
        let dataSite = item.site;

        let dataStage = item.stage;

        let pipelineRelocationData = {};
        let stageData = {};
        if (line == dataLine) {
            if (!pipelineRelocation[dataSite]) pipelineRelocation[dataSite] = {site:item.site, state:item.state, data:{}};
            if (!pipelineRelocation[dataSite]["data"][item.title]) pipelineRelocation[dataSite]["data"][item.title] = {};

            if (dataStage) {
                for (let name = 0; name < stageConf.length; name++) {
                    stageData[stageConf[name]] = item[stageConf[name]];
                }
                stageList.push(stageData);
                pipelineRelocation[dataSite]["data"][item.title] = stageList;
            } else {
                for (let name = 0; name < conf.length; name++) {
                    pipelineRelocationData[conf[name]] = item[conf[name]];
                }
                pipelineRelocation[dataSite]["data"][item.title] = pipelineRelocationData;
            }
            
        }
    });

    let pipelineRelocationList = [];
    for (let key in pipelineRelocation[site]["data"]) {
        pipelineRelocationList.push({title: key, list: pipelineRelocation[site]["data"][key]});
    }

    pipelineRelocation[site]["data"] = pipelineRelocationList;

    let result = {"pipelineRelocation": pipelineRelocation[site]};

    res.send(result);

    return result;
}


/**
 * 管道搬迁弹窗详情
 * @param id 管线搬迁编号
 * @returns details: [{ name:"管线电力名称", dataList:[{数据列表}, ...... ] }, ...... ]
 * dataList:[{
 *      relocateName:"搬迁进度名称",
 *      relocateState:"进度状态"
 * }, ...... ]
 */
export async function getPipelineRelocationDetails(req, res) {
    let id = req.query.id || "17号线西岑站1";
    let tableData = pipelineRelocationDetailsTableData();

    let result:any = {};

    result["details"] = getPopupDetailsData(id, tableData, ["powerName", "relocateName", "relocateState"], ["relocateName", "relocateState"], "powerName");

    res.send(result);

    return result;
}