/**
 * 建设指挥 
 * 在建站点弹窗
 * 参建单位 
 * 4.0
 * 处理数据
 */

import { participatingUnitsDefault, participatingUnitsListDefault } from "../../config/defaultConfig";
import { participatingUnitsTableData } from "../../data/table/stationPopupData";
import { change, getPopupOneData } from "../../dataPackage/inBackOut";

/**
 * 参建单位
 * @param line 线路名称
 * @param site 站点名称
 * @returns participatingUnits: { site:"站点名称", state:"站点状态"}
 * @returns dataList: [ { key:"数据名称", value:数据值, unit:"单位" }, ......  ]
 * key："建设单位", "勘察单位", "设计单位", "施工单位", "监理单位", "第三方检测单位", "环境检测单位"
 */
export async function getParticipatingUnits(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = participatingUnitsTableData();
    
    //"线路", "站点名称", "站点状态", "建设单位", "勘察单位", "设计单位", "施工单位", "监理单位", "第三方检测单位", "环境检测单位" 
    let data = change(["line", "site", "state", "建设单位", "勘察单位", "设计单位", "施工单位", "监理单位", "第三方检测单位", "环境检测单位"], tableData["参建单位数据"].bodyList );

    let conf = ["site", "state"];
    let participatingUnits = getPopupOneData(line, data, conf);

    let dataListConf = ["建设单位", "勘察单位", "设计单位", "施工单位", "监理单位", "第三方检测单位", "环境检测单位"];
    let dataList =  getPopupOneData(line, data, dataListConf);

    let participatingUnitsList = [];
    for(let key in dataList[site]) {
        participatingUnitsList.push({key, value: dataList[site][key]});
    }

    let result = {};

    result["participatingUnits"] = participatingUnits[site] || participatingUnitsDefault;
    result["dataList"] = participatingUnitsList || participatingUnitsListDefault;

    res.send(result);

    return result;
}
