/**
 * 建设指挥 
 * 在建站点弹窗
 * 前期证照 
 * 4.0
 * 处理数据
 */

import { earlyCertificationDefault } from "../../config/defaultConfig";
import { earlyCertificationTableData } from "../../data/table/stationPopupData";
import { change } from "../../dataPackage/inBackOut";

let moment = require("moment");
moment.suppressDeprecationWarnings = true;


/**
 * 前期证照
 * @param line 线路名称
 * @param site 站点名称
 * @returns earlyCertification: { site:"站点名称", state:"站点状态", data:[{数据列表}, ...... ] }
 * data:[{
 *      licenseName:"证照名称", completionStatus:"完成状态", plannedCompletionTime:"计划完成时间", actualCompletionTime:"实际完成时间", delayDays:"延期天数", 
 *      daysRemaining:"剩余天数", expirationTime:"到期时间", landBorrowingFees:"借地费用", untilExpiration:"距离到期时间", earlyWarning:"是否预警", fileAddress:"文件地址"
 * }, ...... ]
 * 没有数据的字段不返回，数据为0的字段照常返回
 * 到期时间、借地费用属于临时用地许可证
 * 1、延期完成状态：显示延期天数 2、未完成：显示剩余天数 3、未到期：显示距离到期时间、是否预警
 */
export async function getEarlyCertification(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = earlyCertificationTableData();
    
    //"线路", "站点名称", "站点状态", "证照名称", "完成状态", "计划完成时间", "实际完成时间", 
    //"到期时间", "借地费用", "文件地址" 
    let data = change(
    ["line", "site", "state", "licenseName", "completionStatus", "plannedCompletionTime", "actualCompletionTime", 
    "expirationTime", "landBorrowingFees", "fileAddress"]
    , tableData["前期证照数据"].bodyList );

    //"证照名称", "完成状态", "计划完成时间", "实际完成时间", "到期时间", "借地费用", 
    //"延期天数", "剩余天数", "距离到期", "是否预警", "文件地址"
    let conf = ["licenseName", "completionStatus", "plannedCompletionTime", "actualCompletionTime", "expirationTime", "landBorrowingFees", 
    "delayDays", "daysRemaining", "untilExpiration", "earlyWarning", "fileAddress"];
    
    let earlyCertification:any = {};

    data.forEach(item => {
        let dataLine = item.line;
        let dataSite = item.site;

        let completionStatus = item.completionStatus;
        let plannedCompletionTime = moment(item.plannedCompletionTime).format("YYYY/MM/DD"); //计划完成时间
        let actualCompletionTime = moment(item.actualCompletionTime).format("YYYY/MM/DD"); //实际完成时间
        let expirationTime = moment(item.expirationTime).format("YYYY/MM/DD"); //到期时间
        let today = moment(new Date()).format("YYYY/MM/DD"); //当前日期

        let pipelineRelocationData = {};
        if (line == dataLine) {
            switch(completionStatus) {
                case "延期完成":
                    item["delayDays"] = moment(actualCompletionTime).diff(plannedCompletionTime, 'day');
                break;
                case "未完成":
                    item["daysRemaining"] = moment(plannedCompletionTime).diff(today, 'day');
                break;
                case "未到期":
                    let {month, day} = monthDayDiff(today, expirationTime);
                    item["untilExpiration"] = `${month}个月${day}天`;
                    item["earlyWarning"] = false; //是否预警
                    if (month < 3) item["earlyWarning"] = true;
                break;
            }
            if (!earlyCertification[dataSite]) earlyCertification[dataSite] = {site:item.site, state:item.state, data:[]};

            for (let name = 0; name < conf.length; name++) {
                pipelineRelocationData[conf[name]] = item[conf[name]];
            }
            earlyCertification[dataSite]["data"].push(pipelineRelocationData);
        }
    });

    
    let result = {"earlyCertification": earlyCertification[site] || earlyCertificationDefault};

    res.send(result);

    return result;
}






/**
 * 前期证照
 * @param line 线路名称
 * @param site 站点名称
 * @returns earlyCertification: { site:"站点名称", state:"站点状态", data:[{数据列表}] }
 * data:[{ 
 *     licenseName:"证照名称",
 *     completionStatus:"完成状态",
 *     fileAddress:"文件地址", 
 *     listData:[
 *          {key:"数据名称", value:"数据值"}, ...... 
 *     ]
 * }, ...... ]
 * 没有数据的字段不返回，数据为0的字段照常返回
 * 到期时间、借地费用属于临时用地许可证
 * 1、延期完成状态：显示延期天数 2、未完成：显示剩余天数 3、未到期：显示距离到期时间、是否预警
 */
// export async function getEarlyCertification(req, res) {
//     let line = req.query.line || "17号线";
//     let site = req.query.site || "西岑站";
//     let tableData = earlyCertificationTableData();
    
//     //"线路", "站点名称", "站点状态", "证照名称", "完成状态", "计划完成时间", "实际完成时间", "到期时间", "借地费用", "文件地址" 
//     // delayDays, daysRemaining, untilExpiration
//     let data = change(
//         ["line", "site", "state", "证照名称", "完成状态", "计划完成时间", "实际完成时间", "到期时间", "借地费用", "文件地址"]
//         , tableData["前期证照数据"].bodyList );

//     let conf = ["证照名称", "完成状态", "到期时间", "借地费用", "文件地址"];
//     let listConf = ["计划完成时间", "实际完成时间", "延期天数", "剩余天数", "距离到期", "是否预警"];
    
//     // let earlyCertification = getPopupMoreData(line, data, conf);
//     let earlyCertification:any = {};

//     data.forEach(item => {
//         let dataLine = item.line;
//         let dataSite = item.site;

//         let completionStatus = item.完成状态;
//         let plannedCompletionTime = moment(item.计划完成时间).format("YYYY/MM/DD"); //计划完成时间
//         let actualCompletionTime = moment(item.实际完成时间).format("YYYY/MM/DD"); //实际完成时间
//         let expirationTime = moment(item.到期时间).format("YYYY/MM/DD"); //到期时间
//         let today = moment(new Date()).format("YYYY/MM/DD"); //当前日期

//         let pipelineRelocationData = {};
//         let listData = [];
//         if (line == dataLine) {
//             switch(completionStatus) {
//                 case "延期完成":
//                     item["延期天数"] = moment(actualCompletionTime).diff(plannedCompletionTime, 'day');
//                 break;
//                 case "未完成":
//                     item["剩余天数"] = moment(plannedCompletionTime).diff(today, 'day');
//                 break;
//                 case "未到期":
//                     let {month, day} = monthDayDiff(today, expirationTime);
//                     item["距离到期"] = `${month}个月${day}天`;
//                     item["是否预警"] = false; //是否预警
//                     if (month < 3) item["是否预警"] = true;
//                 break;
//             }
//             if (!earlyCertification[dataSite]) earlyCertification[dataSite] = {site:item.site, state:item.state, data:[]};

//             for (let name = 0; name < conf.length; name++) {
//                 pipelineRelocationData[conf[name]] = item[conf[name]];
//             }

//             for (let name = 0; name < listConf.length; name++) {
//                 item["是否预警"] = String(item["是否预警"]);
//                 if (item[listConf[name]] && item[listConf[name]] != "undefined") listData.push({key: listConf[name], value: item[listConf[name]]})
//             }

//             pipelineRelocationData["listData"] = listData;
//             earlyCertification[dataSite]["data"].push(pipelineRelocationData);

//         }
//     });
    
//     let result = {"earlyCertification": earlyCertification[site] || earlyCertificationDefault};

//     res.send(result);

//     return result;
// }



/**
 * 获取日期之间间隔几个月零几天
 * @param startDate 开始时间
 * @param endDate 结束时间
 * @returns 
 */
function monthDayDiff(startDate, endDate) {
    let flag = [1, 3, 5, 7, 8, 10, 12, 4, 6, 9, 11, 2];
    let start = new Date(startDate);
    let end = new Date(endDate);
    let year = end.getFullYear() - start.getFullYear();
    let month = end.getMonth() - start.getMonth();
    let day = end.getDate() - start.getDate();
    if (month < 0) {
        year--;
        month = end.getMonth() + (12 - start.getMonth());
    }
    if (day < 0) {
        month--;
        let index = flag.findIndex((temp) => {
            return temp === start.getMonth() + 1
        });
        let monthLength;
        if (index <= 6) {
            monthLength = 31;
        } else if (index > 6 && index <= 10) {
            monthLength = 30;
        } else {
            monthLength = 28;
        }
        day = end.getDate() + (monthLength - start.getDate());
    }

    month = 12 * year + month;

    return {month, day};
}