/**
 * 建设指挥 
 * 在建站点弹窗
 * 建设里程碑 
 * 4.0
 * 处理数据
 */

import { constructionMilestonesTableData } from "../../data/table/stationPopupData";
import { change, getPopupMoreData } from "../../dataPackage/inBackOut";


/**
 * 建设里程碑
 * @param line 线路名称
 * @param site 站点名称
 * @returns constructionMilestones: { site:"站点名称", state:"站点状态", data:[{数据列表}, ...... ]}
 * data:[{ constructionContent:"建设内容", constructionTime:"时间", constructionStatus:"建设状态" }, ...... ]
 */
export async function getConstructionMilestones(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = constructionMilestonesTableData();
    
    //"线路", "站点名称", "站点状态", "建设内容", "实际完成时间", "计划完成时间", "建设状态"
    let data = change(["line", "site", "state", "constructionContent", "constructionTime", "plannedCompletionTime", "constructionStatus"], tableData["建设里程碑数据"].bodyList );

    let conf = ["constructionContent", "constructionTime", "plannedCompletionTime", "constructionStatus"];
    
    let constructionMilestones = getPopupMoreData(line, data, conf);

    let result = {"constructionMilestones": constructionMilestones[site]};

    res.send(result);

    return result;
}



