/**
 * 建设指挥 
 * 在建站点弹窗
 * 建设资料 
 * 3.0
 * 处理数据
 */

import { constructionMaterialsDetailsTableData, constructionMaterialsTableData } from "../../data/table/stationPopupData";
import { change, getPopupDetailsData, getPopupMoreData } from "../../dataPackage/inBackOut";


/**
 * 建设资料
 * @param line 线路名称 
 * @param site 站点名称
 * @returns constructionMaterials: {site: "站点名称", state: "站点状态", data: [{数据列表}]}
 * data: [{informationType: "资料类型", informationNum: 资料数量, informationId: "建设资料编号" }, ...... ]
 */
export async function getConstructionMaterials(req, res) {
    let line = req.query.line || "17号线";
    let site = req.query.site || "西岑站";
    let tableData = constructionMaterialsTableData();
    
    //"线路", "站点名称", "站点状态", "资料类型", "资料数量", "资料编号"
    let data = change(["line", "site", "state", "informationType", "informationNum", "informationId"], tableData["建设资料数据"].bodyList );

    let conf = ["informationType", "informationNum", "informationId"];
    
    let constructionMaterials = getPopupMoreData(line, data, conf);

    constructionMaterials[site]["total"] = constructionMaterials[site]["data"].length || 0;

    let result = {"constructionMaterials": constructionMaterials[site]};

    res.send(result);

    return result;
}


/**
 * 建设资料详情
 * @param informationId 建设资料编号
 * @param informationType 资料类型
 * @param informationName 资料名称
 * @returns type:["资料类型", ......], details:[{ name:"资料名称", value:"资料地址" }, { name:"", value:"" }, ...... ]
 */
export async function getConstructionMaterialsDetails(req, res) {
    let informationId = req.query.informationId || "17号线西岑站1";
    let informationType = req.query.informationType || "图纸资料"
    let informationName = req.query.informationName; //资料名称

    let tableData = constructionMaterialsDetailsTableData();

    let result:any = {};

    let details:any = {};
    let informationTypeList = [];
    for (let key in tableData) {
        if (informationId == key) {
            let data = change(["informationType", "informationName", "informationUrl"], tableData[key].bodyList );
        
            data.forEach(item => {
                let itemName = item["informationType"];

                if (!details[itemName]) details[itemName] = [];
                if (!informationName) {
                    details[itemName].push({name: item["informationName"], url: item["informationUrl"]});
                } else {
                    if (informationName === item["informationName"]) {
                        details[itemName].push({name: item["informationName"], url: item["informationUrl"]});
                    }
                }
                
            });

        }
    }

    for (let key in details) {
        informationTypeList.push(key);
    }

    result["type"] = informationTypeList;
    result["details"] = details[informationType];

    res.send(result);

    return result;
}